/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.AfterCommit;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.OnAbort;
import net.e6tech.elements.common.resources.OnClosed;
import net.e6tech.elements.common.resources.OnCommit;
import net.e6tech.elements.common.resources.OnOpen;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.ResourcesState;
import net.e6tech.elements.common.resources.Retry;
import net.e6tech.elements.common.resources.Transactional;
import net.e6tech.elements.common.resources.plugin.Path;
import net.e6tech.elements.common.resources.plugin.Pluggable;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.util.ExceptionMapper;

@BindClass(value=Resources.class)
public class Resources
implements AutoCloseable,
ResourcePool {
    private static final String TIMEOUT = Resources.class.getName() + ".timeout";
    private static final String TIMEOUT_EXTENSION = Resources.class.getName() + ".timeout.extension";
    private static Logger logger = Logger.getLogger(Resources.class);
    @Inject
    private ResourceManager resourceManager;
    @Inject(optional=true)
    private Retry retry;
    protected ResourcesState state = new ResourcesState();
    private Consumer<? extends Resources> preOpen;
    private List<Replay<? extends Resources, ?>> unitOfWork = new LinkedList();
    Object lastResult;
    boolean submitting = false;

    protected Resources() {
        this.getModule().bindInstance(this.getClass(), this);
    }

    public long getTimeout() {
        return this.getConfiguration(TIMEOUT, 0L);
    }

    public void setTimeout(long timeout) {
        this.setConfiguration(TIMEOUT, timeout);
    }

    public long getTimeoutExtension() {
        return this.getConfiguration(TIMEOUT_EXTENSION, 0L);
    }

    public void setTimeoutExtension(long timeout) {
        this.setConfiguration(TIMEOUT_EXTENSION, timeout);
    }

    void setPreOpen(Consumer<? extends Resources> preOpen) {
        this.preOpen = preOpen;
    }

    public synchronized boolean isCommitted() {
        return this.state.isCommitted();
    }

    private void setCommitted(boolean committed) {
        this.state.setCommitted(committed);
    }

    public synchronized boolean isOpened() {
        return this.state.isOpened();
    }

    private void setOpened(boolean opened) {
        this.state.setOpened(opened);
    }

    public synchronized boolean isAborted() {
        return this.state.isAborted();
    }

    private void setAborted(boolean aborted) {
        this.state.setAborted(aborted);
    }

    public synchronized boolean isClosed() {
        return !this.isOpened();
    }

    public synchronized boolean isDiscarded() {
        return this.resourceManager == null;
    }

    private List<ResourceProvider> getResourceProviders() {
        return this.state.getResourceProviders();
    }

    public synchronized void addResourceProvider(ResourceProvider resourceProvider) {
        this.getResourceProviders().add(resourceProvider);
        if (this.isOpened() && !this.isAborted() && !this.isCommitted()) {
            resourceProvider.onOpen(this);
        }
        if (this.isCommitted()) {
            resourceProvider.onCommit(this);
        }
        if (this.isCommitted()) {
            resourceProvider.afterCommit(this);
        }
        if (this.isAborted()) {
            resourceProvider.onAbort(this);
        }
    }

    public void onCommit(OnCommit onCommit) {
        this.addResourceProvider(onCommit);
    }

    public void onCommit(Runnable runnable) {
        OnCommit on = res -> runnable.run();
        this.onCommit(on);
    }

    public void afterCommit(AfterCommit afterCommit) {
        this.addResourceProvider(afterCommit);
    }

    public void afterCommit(Runnable runnable) {
        AfterCommit after = res -> runnable.run();
        this.afterCommit(after);
    }

    public synchronized void onOpen(OnOpen onOpen) {
        this.addResourceProvider(onOpen);
    }

    public synchronized void onOpen(Runnable runnable) {
        OnOpen on = res -> runnable.run();
        this.onOpen(on);
    }

    public synchronized void onAbort(OnAbort onAbort) {
        this.addResourceProvider(onAbort);
    }

    public synchronized void onAbort(Runnable runnable) {
        OnAbort on = res -> runnable.run();
        this.onAbort(on);
    }

    public synchronized void onClosed(OnClosed onClosed) {
        this.addResourceProvider(onClosed);
    }

    public synchronized void onClosed(Runnable runnable) {
        OnClosed on = res -> runnable.run();
        this.onClosed(on);
    }

    public synchronized boolean remove(ResourceProvider provider) {
        return this.getResourceProviders().remove(provider);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public <T extends Pluggable> T getPlugin(Class c1, String n1, Class c2, Object ... args) {
        return (T)this.getPlugin(Path.of(c1, n1).and(c2), args);
    }

    public <T extends Pluggable> T getPlugin(Class c1, String n1, Class c2, String n2, Class c3, Object ... args) {
        return (T)this.getPlugin(Path.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Pluggable> T getPlugin(Path<T> path, Object ... args) {
        Plugin plugin = this.getInstance(Plugin.class);
        return plugin.from(this).get(path, args);
    }

    private Map<String, Object> getContext() {
        return this.state.getContext();
    }

    public <T> Resources put(Class<T> cls, T obj) {
        this.getContext().put(cls.getName(), obj);
        return this;
    }

    public <T> Resources put(String name, T obj) {
        if (obj == null) {
            return this;
        }
        this.getContext().put(name, obj);
        return this;
    }

    public <T> Resources put(Enum value) {
        if (value == null) {
            return this;
        }
        this.getContext().put(value.getClass() + "::" + value.name(), value);
        return this;
    }

    public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return (T)this.getContext().computeIfAbsent(key, mappingFunction);
    }

    public <T> T computeIfAbsent(Class<T> key, Function<String, T> mappingFunction) {
        return (T)this.getContext().computeIfAbsent(key.getName(), mappingFunction);
    }

    public <T> T getVariable(String variable) {
        return this.resourceManager.getVariable(variable);
    }

    public <T> T get(Class<T> cls) {
        return (T)this.getContext().get(cls.getName());
    }

    public <T> T get(String name) {
        return (T)this.getContext().get(name);
    }

    public <T> T get(Enum value) {
        return (T)this.getContext().get(value.getClass() + "::" + value.name());
    }

    public InjectionModule getModule() {
        return this.state.getModule();
    }

    public void addModule(InjectionModule module) {
        this.state.addModule(module);
    }

    public <T> Binding<T> getBinding(Class<T> cls) {
        Binding<T> boundInstance = new Binding<T>(this, cls);
        return boundInstance;
    }

    public <T> T tryBind(Class<T> cls, Callable<T> callable) {
        return this.state.tryBind(this, cls, callable);
    }

    public <T> boolean isBound(Class<T> cls) {
        return this.getModule().getBoundInstance(cls) != null;
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        return this.state.bind(this, cls, resource);
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        return this.state.rebind(this, cls, resource);
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        return this.state.unbind(cls);
    }

    @Override
    public void bindClass(Class cls, Class service) {
        this.state.bindClass(cls, service);
    }

    @Override
    public <T> T bindNamedInstance(String name, Class<T> cls, T resource) {
        return this.state.bindNamedInstance(name, cls, resource);
    }

    @Override
    public <T> T rebindNamedInstance(String name, Class<T> cls, T resource) {
        return this.state.rebindNamedInstance(name, cls, resource);
    }

    public <T> T getBoundNamedInstance(String name) {
        return this.getModule().getBoundNamedInstance(name);
    }

    @Override
    public <T> T inject(T object) {
        return this.state.inject(this, object);
    }

    public boolean hasInstance(Class cls) {
        return this.state.hasInstance(this, cls);
    }

    public <T> T getInstance(Class<T> cls) throws InstanceNotFoundException {
        return this.state.getInstance(this, cls);
    }

    protected Map<String, Object> getConfiguration() {
        return this.state.getConfiguration();
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.state.setConfiguration(configuration);
    }

    public <T> T getConfiguration(String key) {
        return (T)this.getConfiguration().get(key);
    }

    public <T> T getConfiguration(String key, T defaultValue) {
        Object value = this.getConfiguration().get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public void setConfiguration(String key, Object object) {
        this.getConfiguration().put(key, object);
    }

    public synchronized void onOpen() {
        this.setAborted(false);
        this.setCommitted(false);
        long start = System.currentTimeMillis();
        this.state.initModules(this);
        if (!this.isOpened()) {
            this.setOpened(true);
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onOpen(this);
            }
        }
    }

    protected <Res extends Resources, R> R replay(Throwable th, Replay<Res, R> replay) {
        if (this.isAborted() || this.retry == null) {
            this.log("Aborting due to exception", th);
            if (!this.isAborted()) {
                this.abort();
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        try {
            return (R)this.retry.retry(th, () -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Resources retrying due to error: ").append(ExceptionMapper.unwrap(th).getClass()).append(", message: ").append(th.getMessage());
                Reflection.printStackTrace(builder, "    ", 2, 8);
                logger.warn(builder.toString());
                try {
                    this.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Resources retryResources = this.resourceManager.open(this.preOpen);
                this.state = retryResources.state;
                Iterator<Replay<Resources, ?>> iterator = this.unitOfWork.iterator();
                while (iterator.hasNext()) {
                    Object ret = iterator.next().replay(this);
                    if (iterator.hasNext()) continue;
                    this.lastResult = ret;
                }
                return replay.replay(this);
            });
        }
        catch (Throwable th2) {
            this.log("Aborting due to exception", th2);
            this.abort();
            if (th2 instanceof RuntimeException) {
                throw (RuntimeException)th2;
            }
            throw new RuntimeException(th2);
        }
    }

    public synchronized <Res extends Resources> void submit(Transactional.ConsumerWithException<Res> work) {
        this.play(new Replay(work));
    }

    public synchronized <Res extends Resources, R> R submit(Transactional.FunctionWithException<Res, R> work) {
        return this.play(new Replay<Res, R>(work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Res extends Resources, R> R play(Replay<Res, R> replay) {
        R ret = null;
        boolean topLevel = !this.submitting;
        this.submitting = true;
        try {
            try {
                ret = replay.replay(this);
            }
            catch (Throwable th) {
                ret = this.replay(th, replay);
            }
            this.lastResult = ret;
        }
        finally {
            if (topLevel) {
                this.submitting = false;
                this.unitOfWork.add(replay);
            }
        }
        return ret;
    }

    private void log(String msg, Throwable th) {
        Provision provision = this.resourceManager.getInstance(Provision.class);
        provision.log(logger, msg, th);
    }

    public synchronized <R> R commit() {
        Object ret = null;
        try {
            ret = this._commit();
        }
        catch (Throwable th) {
            ret = this.replay(th, new Replay<Resources, Object>(res -> this._commit()));
        }
        finally {
            if (!this.isAborted()) {
                this.cleanup();
            }
        }
        return (R)ret;
    }

    private <R> R _commit() {
        ResourceProvider resourceProvider;
        Object ret = null;
        if (this.resourceManager == null) {
            return null;
        }
        if (this.isAborted()) {
            return (R)this.lastResult;
        }
        if (!this.isOpened()) {
            throw new IllegalStateException("Already closed");
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            resourceProvider.onCommit(this);
            if (!this.isAborted()) continue;
            return (R)this.lastResult;
        }
        for (ResourceProvider p : this.resourceManager.getResourceProviders()) {
            p.onCommit(this);
        }
        for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
            resourceProvider = this.state.getResourceProviders().get(i);
            try {
                resourceProvider.afterCommit(this);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setCommitted(true);
        ret = this.lastResult;
        return (R)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        try {
            if (this.resourceManager == null) {
                return;
            }
            if (!this.isAborted()) {
                for (int i = 0; i < this.state.getResourceProviders().size(); ++i) {
                    ResourceProvider resourceProvider = this.state.getResourceProviders().get(i);
                    try {
                        resourceProvider.onAbort(this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                for (ResourceProvider p : this.resourceManager.getResourceProviders()) {
                    try {
                        p.onAbort(this);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            this.cleanup();
            this.setAborted(true);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isOpened()) {
            return;
        }
        if (!this.isAborted()) {
            this.commit();
        } else {
            this.abort();
        }
    }

    synchronized void discard() {
        this.resourceManager = null;
        this.state.discard();
    }

    private void cleanup() {
        try {
            for (ResourceProvider resourceProvider : this.state.getResourceProviders()) {
                resourceProvider.onClosed(this);
            }
            for (ResourceProvider p : this.resourceManager.getResourceProviders()) {
                p.onClosed(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state.cleanup();
        this.getModule().bindInstance(Resources.class, this);
        this.lastResult = null;
    }

    public <T extends Provision> T provision() {
        return (T)this.getInstance(Provision.class);
    }

    private static class Replay<Res, R> {
        Transactional.ConsumerWithException<Res> consumer;
        Transactional.FunctionWithException<Res, R> function;

        Replay(Transactional.ConsumerWithException<Res> work) {
            this.consumer = work;
        }

        Replay(Transactional.FunctionWithException<Res, R> work) {
            this.function = work;
        }

        R replay(Res res) throws Throwable {
            if (this.consumer != null) {
                this.consumer.accept(res);
                return null;
            }
            return this.function.apply(res);
        }
    }
}

