/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources.plugin;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import net.e6tech.elements.common.resources.Binding;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.Path;
import net.e6tech.elements.common.resources.plugin.Pluggable;
import net.e6tech.elements.common.util.InitialContextFactory;
import net.e6tech.elements.common.util.file.FileUtil;

public class Plugin {
    private static final String DEFAULT_PLUGIN = "defaultPlugin";
    private PluginClassLoader classLoader;
    private Context context;
    private ResourceManager resourceManager;
    private Resources resources;
    private Map<Class, Object> defaultPlugins = new HashMap<Class, Object>();

    public Plugin from(Resources resources) {
        Plugin plugin = new Plugin(this.resourceManager);
        plugin.resources = resources;
        plugin.context = this.context;
        plugin.defaultPlugins = this.defaultPlugins;
        plugin.classLoader = this.classLoader;
        return plugin;
    }

    public Plugin(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.classLoader = new PluginClassLoader(resourceManager.getClass().getClassLoader());
        this.context = new InitialContextFactory().createContext(new Hashtable());
    }

    public void loadPlugins(String[] directories) {
        for (String dir : directories) {
            java.nio.file.Path[] paths = new java.nio.file.Path[]{};
            try {
                paths = FileUtil.listFiles(dir, "jar");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (java.nio.file.Path p : paths) {
                try {
                    this.classLoader.addURL(p.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    public <T extends Pluggable> T get(Class c1, String n1, Class c2, Object ... args) {
        return (T)this.get(Path.of(c1, n1).and(c2), args);
    }

    public <T extends Pluggable> T get(Class c1, String n1, Class c2, String n2, Class c3, Object ... args) {
        return (T)this.get(Path.of(c1, n1).and(c2, n2).and(c3), args);
    }

    public <T extends Pluggable> T get(Path<T> path, Object ... args) {
        Pluggable plugin;
        Object lookup;
        block17: {
            String fullPath = path.path();
            lookup = null;
            try {
                lookup = this.context.lookup(fullPath);
            }
            catch (NamingException e) {
                Class<T> type;
                Object[] plugin2 = this.defaultPlugins.get(type);
                if (lookup != null) break block17;
                for (type = path.getType(); type != null && !type.equals(Object.class); type = type.getSuperclass()) {
                    try {
                        Field field = type.getField(DEFAULT_PLUGIN);
                        lookup = field.get(null);
                        this.defaultPlugins.put(path.getType(), lookup);
                        break;
                    }
                    catch (NoSuchFieldException field) {
                        continue;
                    }
                    catch (IllegalAccessException field) {
                        // empty catch block
                    }
                }
                if (lookup != null) break block17;
                throw new RuntimeException("Invalid plugin path: " + fullPath);
            }
        }
        if (lookup instanceof Class) {
            try {
                plugin = (Pluggable)((Class)lookup).newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            plugin = (Pluggable)lookup;
        }
        if (args != null && args.length > 0) {
            InjectionModule module = new InjectionModule();
            for (Object arg : args) {
                if (arg instanceof Binding) {
                    Binding binding = (Binding)arg;
                    if (binding.getName() != null) {
                        module.bindNamedInstance(binding.getName(), binding.getBoundClass(), binding.get());
                        continue;
                    }
                    module.bindInstance(binding.getBoundClass(), binding.get());
                    continue;
                }
                module.bindInstance(arg.getClass(), arg);
            }
            ArrayList<InjectionModule> modules = new ArrayList<InjectionModule>();
            modules.add(module);
            if (this.resources != null) {
                modules.add(this.resources.getModule());
            }
            modules.add(this.resourceManager.getModule());
            Injector injector = Guice.createInjector(modules);
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).preInject(this.resources);
            }
            injector.injectMembers((Object)plugin);
            if (plugin instanceof InjectionListener) {
                ((InjectionListener)((Object)plugin)).injected(this.resources);
            }
        }
        plugin.initialize();
        return (T)plugin;
    }

    public <T extends Pluggable> void add(Class c1, String n1, Class<T> c2, T instance) {
        this.add(Path.of(c1, n1).and(c2), instance);
    }

    public <T extends Pluggable> void add(Class c1, String n1, Class<T> c2, Class<T> implClass) {
        this.add(Path.of(c1, n1).and(c2), (T)((Object)implClass));
    }

    public <T extends Pluggable> void add(Class c1, String n1, Class c2, String n2, Class<T> c3, T object) {
        this.add(Path.of(c1, n1).and(c2, n2).and(c3), object);
    }

    public <T extends Pluggable> void add(Class c1, String n1, Class c2, String n2, Class<T> c3, Class<T> implClass) {
        this.add(Path.of(c1, n1).and(c2, n2).and(c3), (T)((Object)implClass));
    }

    public <T extends Pluggable> void add(Path<T> path, Class<T> cls) {
        try {
            this.context.rebind(path.path(), cls);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Pluggable> void add(Path<T> path, T object) {
        try {
            this.context.rebind(path.path(), object);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Pluggable> void addDefault(Class<T> cls, T object) {
        this.defaultPlugins.put(cls, object);
    }

    public <T extends Pluggable> void addDefault(Class<T> cls, Class<T> implClass) {
        this.defaultPlugins.put(cls, implClass);
    }

    public static class PluginClassLoader
    extends URLClassLoader {
        public PluginClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

