/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.e6tech.elements.common.logging.ExceptionLogger;
import net.e6tech.elements.common.logging.LogLevel;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.Rethrowable;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LogHandler
implements InvocationHandler {
    private static String logDir;
    private static ConsoleLogger consoleLogger;
    private org.slf4j.Logger slf4jLogger;
    private Class loggingClass;
    private String loggingName;
    private LogLevel level = LogLevel.ERROR;
    ExceptionLogger exceptionLogger = new ExceptionLogger(){

        @Override
        public Logger exceptionLogger(LogLevel level) {
            LogHandler handler = new LogHandler(LogHandler.this.slf4jLogger);
            handler.level = level;
            return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)handler);
        }
    };
    Rethrowable rethrowable = new Rethrowable(){

        @Override
        public RuntimeException runtimeException(String msg, Throwable th) {
            RuntimeException t = Rethrowable.super.runtimeException(msg, th);
            this.log(msg, th);
            return t;
        }

        @Override
        public <T extends Throwable> T exception(Class<T> exceptionClass, String msg, Throwable e) {
            T t = Rethrowable.super.exception(exceptionClass, msg, e);
            this.log(msg, e);
            return t;
        }

        protected void log(String msg, Throwable e) {
            if (LogHandler.this.getLogger() != null) {
                switch (LogHandler.this.level) {
                    case FATAL: 
                    case ERROR: {
                        LogHandler.this.getLogger().error(msg, e);
                        break;
                    }
                    case WARN: {
                        LogHandler.this.getLogger().warn(msg, e);
                        break;
                    }
                    case INFO: {
                        LogHandler.this.getLogger().info(msg, e);
                        break;
                    }
                    case DEBUG: {
                        LogHandler.this.getLogger().debug(msg, e);
                        break;
                    }
                    case TRACE: {
                        LogHandler.this.getLogger().trace(msg, e);
                    }
                }
            } else {
                System.out.println(msg);
                e.printStackTrace(System.out);
            }
        }
    };

    public LogHandler(org.slf4j.Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    public LogHandler(Class cls) {
        this.loggingClass = cls;
    }

    public LogHandler(String name) {
        this.loggingName = name;
    }

    protected org.slf4j.Logger getLogger() {
        if (this.slf4jLogger != null) {
            return this.slf4jLogger;
        }
        if (this.loggingClass == null && this.slf4jLogger == null && this.loggingName == null) {
            return null;
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            return consoleLogger;
        }
        if (ThreadContext.get((String)"logDir") == null) {
            if (logDir == null) {
                if (System.getProperty("logDir") != null) {
                    logDir = System.getProperty("logDir");
                } else if (System.getProperty("elements.common.logging.logDir") != null) {
                    logDir = System.getProperty("elements.common.logging.logDir");
                }
            }
            if (logDir == null) {
                return consoleLogger;
            }
            ThreadContext.put((String)"logDir", (String)logDir);
        }
        if (this.loggingClass != null) {
            this.slf4jLogger = LoggerFactory.getLogger((Class)this.loggingClass);
        } else if (this.loggingName != null) {
            this.slf4jLogger = LoggerFactory.getLogger((String)this.loggingName);
        }
        this.loggingClass = null;
        this.loggingName = null;
        return this.slf4jLogger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Rethrowable.class)) {
            return method.invoke((Object)this.rethrowable, args);
        }
        if (method.getDeclaringClass().equals(ExceptionLogger.class)) {
            return method.invoke((Object)this.exceptionLogger, args);
        }
        org.slf4j.Logger logger = this.getLogger();
        if (logger == null) {
            return null;
        }
        return method.invoke((Object)logger, args);
    }

    static {
        System.setProperty("java.util.logging.manager", "net.e6tech.elements.common.logging.jul.LogManager");
        consoleLogger = new ConsoleLogger();
    }

    private static class ConsoleLogger
    implements org.slf4j.Logger {
        private ConsoleLogger() {
        }

        public String getName() {
            return "ConsoleLogger";
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void trace(String msg) {
        }

        public void trace(String format, Object arg) {
        }

        public void trace(String format, Object arg1, Object arg2) {
        }

        public void trace(String format, Object ... arguments) {
        }

        public void trace(String msg, Throwable t) {
            this.info(msg, t);
        }

        public boolean isTraceEnabled(Marker marker) {
            return false;
        }

        public void trace(Marker marker, String msg) {
        }

        public void trace(Marker marker, String format, Object arg) {
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void trace(Marker marker, String format, Object ... arguments) {
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.info(marker, msg, t);
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(String msg) {
        }

        public void debug(String format, Object arg) {
        }

        public void debug(String format, Object arg1, Object arg2) {
        }

        public void debug(String format, Object ... arguments) {
        }

        public void debug(String msg, Throwable t) {
            this.info(msg, t);
        }

        public boolean isDebugEnabled(Marker marker) {
            return false;
        }

        public void debug(Marker marker, String msg) {
        }

        public void debug(Marker marker, String format, Object arg) {
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void debug(Marker marker, String format, Object ... arguments) {
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.info(marker, msg, t);
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public void info(String msg) {
            System.out.println(msg);
        }

        public void info(String format, Object arg) {
            System.out.println(format + " -> " + arg);
        }

        public void info(String format, Object arg1, Object arg2) {
            System.out.println(format + " -> " + arg1 + "," + arg2);
        }

        public void info(String format, Object ... arguments) {
            System.out.print(format + " -> ");
            if (arguments != null) {
                boolean first = true;
                for (Object o : arguments) {
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(",");
                    }
                    System.out.print(o);
                }
                System.out.println();
            }
        }

        public void info(String msg, Throwable t) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace(System.out);
                System.out.println();
            }
        }

        public boolean isInfoEnabled(Marker marker) {
            return true;
        }

        public void info(Marker marker, String msg) {
            this.info(marker + ": " + msg);
        }

        public void info(Marker marker, String format, Object arg) {
            this.info(marker + ": " + format, arg);
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.info(marker + ": " + format, arg1, arg2);
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.info(marker + ": " + format, arguments);
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.info(marker + ": " + msg, t);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void warn(String msg) {
            this.info(msg);
        }

        public void warn(String format, Object arg) {
            this.info(format, arg);
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.info(format, arg1, arg2);
        }

        public void warn(String format, Object ... arguments) {
            this.info(format, arguments);
        }

        public void warn(String msg, Throwable t) {
            this.info(msg, t);
        }

        public boolean isWarnEnabled(Marker marker) {
            return true;
        }

        public void warn(Marker marker, String msg) {
            this.info(marker, msg);
        }

        public void warn(Marker marker, String format, Object arg) {
            this.info(marker, format, arg);
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.info(marker, format, arg1, arg2);
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.info(marker, format, arguments);
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.info(marker, msg, t);
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public void error(String msg) {
            this.info(msg);
        }

        public void error(String format, Object arg) {
            this.info(format, arg);
        }

        public void error(String format, Object arg1, Object arg2) {
            this.info(format, arg1, arg2);
        }

        public void error(String format, Object ... arguments) {
            this.info(format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.info(msg, t);
        }

        public boolean isErrorEnabled(Marker marker) {
            return true;
        }

        public void error(Marker marker, String msg) {
            this.info(marker, msg);
        }

        public void error(Marker marker, String format, Object arg) {
            this.info(marker, format, arg);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.info(marker, format, arg1, arg2);
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.info(marker, format, arguments);
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.info(marker, msg, t);
        }
    }
}

