/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class TextSubstitution {
    private Map<String, Var> variables = new LinkedHashMap<String, Var>();
    private Map<String, Var> declared = new LinkedHashMap<String, Var>();
    private String template;

    public TextSubstitution(String template) {
        this.template = template;
    }

    public TextSubstitution(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int len = 0;
        while ((len = reader.read(buffer)) >= 0) {
            builder.append(buffer, 0, len);
        }
        this.template = builder.toString();
        reader.close();
    }

    public TextSubstitution declare(String var) {
        this.declared.put(var, new Var(var));
        return this;
    }

    public String build(Object binding, String ... declares) {
        if (this.template == null) {
            return "";
        }
        if (declares != null) {
            for (String string : declares) {
                this.declared.put(string, new Var(string));
            }
        }
        this.parseVariableNames(this.template);
        String text = this.template;
        for (Map.Entry<String, Var> entry : this.variables.entrySet()) {
            Var var = entry.getValue();
            text = this.replaceVariable(entry.getKey(), var.build(binding), text);
        }
        return text;
    }

    private String replaceVariable(String key, String value, String text) {
        return text.replaceAll("\\$\\{" + key + "}", value);
    }

    private void parseVariableNames(String text) {
        int end;
        LinkedList<String> names = new LinkedList<String>();
        int pos = 0;
        int max = text.length();
        while (pos < max && (pos = text.indexOf("${", pos)) != -1 && (end = text.indexOf("}", pos + 2)) != -1) {
            String name = text.substring(pos + 2, end);
            names.add(name);
            pos = end + 1;
        }
        for (String name : names) {
            int index;
            String key = name.trim();
            String defVal = null;
            String strategy = null;
            if (name.contains(":-")) {
                int index2 = name.indexOf(":-");
                if (index2 > 0) {
                    key = name.substring(0, index2).trim();
                    defVal = name.substring(index2 + 2).trim();
                    strategy = ":-";
                }
            } else if (name.contains(":") && (index = name.indexOf(":")) > 0) {
                key = name.substring(0, index).trim();
                defVal = name.substring(index + 1).trim();
                strategy = ":";
            }
            String[] tokens = key.split("\\.");
            Var var = this.declared.get(tokens[0]);
            var = var == null ? new Var(name) : var.clone();
            var.defaultValue = defVal;
            var.strategy = strategy;
            var.path = tokens;
            this.variables.put(name, var);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static class Var
    implements Cloneable {
        String name;
        String defaultValue;
        String strategy;
        String[] path;

        Var(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String build(Object object) {
            Object result = object;
            for (String comp : this.path) {
                try {
                    if (result == null) break;
                    if (result instanceof Map) {
                        result = ((Map)result).get(comp);
                        continue;
                    }
                    PropertyDescriptor desc = new PropertyDescriptor(comp, result.getClass(), "is" + TextSubstitution.capitalize(comp), null);
                    result = desc.getReadMethod().invoke(result, new Object[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            if (result == null) {
                if (":-".equals(this.strategy)) {
                    return "";
                }
                if (":".equals(this.strategy)) {
                    return this.defaultValue == null ? "" : this.defaultValue;
                }
                return "";
            }
            if (":-".equals(this.strategy)) {
                return this.defaultValue;
            }
            if (":".equals(this.strategy)) {
                return result.toString();
            }
            return result.toString();
        }

        public Var clone() {
            try {
                return (Var)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

