/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.util.monitor;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import net.e6tech.elements.common.util.monitor.TimeoutListener;

public class TimeoutMonitor {
    long timeout = -1L;
    @Inject(optional=true)
    ExecutorService threadPool;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void monitor(TimeoutListener listener) {
        long initialTimeout;
        if (listener.getTimeout() < 0L) {
            return;
        }
        long l = initialTimeout = listener.getTimeout() == 0L ? this.timeout : listener.getTimeout();
        if (initialTimeout > 0L && this.threadPool != null) {
            Runnable runnable = () -> {
                long start = System.currentTimeMillis();
                long sleep = 100L;
                while (sleep >= 0L) {
                    long t;
                    long l = t = listener.getTimeout() == 0L ? this.timeout : listener.getTimeout();
                    if (!listener.isOpen()) break;
                    if (System.currentTimeMillis() - start > t) {
                        if (!this.rollback(listener)) continue;
                        break;
                    }
                    if (t - (System.currentTimeMillis() - start) < 100L) {
                        sleep = t - (System.currentTimeMillis() - start);
                    }
                    if (sleep < 100L && (sleep = t - (System.currentTimeMillis() - start) - 10L) < 10L) {
                        sleep = t - (System.currentTimeMillis() - start) - 1L;
                    }
                    try {
                        if (sleep < 0L) continue;
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.rollback(listener);
            };
            if (this.threadPool != null) {
                this.threadPool.execute(runnable);
            } else {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    protected boolean rollback(TimeoutListener listener) {
        if (listener.isOpen()) {
            listener.onTimeout();
            return true;
        }
        return false;
    }
}

