/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.interceptor;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import net.e6tech.elements.common.interceptor.InterceptorHandler;

public class Interceptor {
    Map<Class, Class> proxyClasses = new Hashtable<Class, Class>(199);
    private static Interceptor instance = new Interceptor();
    private boolean useWriteReplace = false;

    public static Interceptor getInstance() {
        return instance;
    }

    public boolean isUseWriteReplace() {
        return this.useWriteReplace;
    }

    public void setUseWriteReplace(boolean useWriteReplace) {
        this.useWriteReplace = useWriteReplace;
    }

    public Class createClass(Class cls) {
        Class proxyClass = this.proxyClasses.get(cls);
        if (proxyClass != null) {
            return proxyClass;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(cls);
        factory.setUseWriteReplace(false);
        factory.setFilter(m -> !m.getName().equals("finalize"));
        proxyClass = factory.createClass();
        this.proxyClasses.put(cls, proxyClass);
        return proxyClass;
    }

    public <T> T newInterceptor(T instance, InterceptorHandler handler) {
        Class proxyClass = this.createClass(instance.getClass());
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(instance, handler);
        ((ProxyObject)proxyObject).setHandler((MethodHandler)wrapper);
        return proxyObject;
    }

    public <T> T newInstance(Class cls, InterceptorHandler handler) {
        Class proxyClass = this.createClass(cls);
        T proxyObject = this.newObject(proxyClass);
        InterceptorHandlerWrapper wrapper = new InterceptorHandlerWrapper(null, handler);
        wrapper.targetClass = cls;
        ((ProxyObject)proxyObject).setHandler((MethodHandler)wrapper);
        return proxyObject;
    }

    private <T> T newObject(Class proxyClass) {
        T proxyObject = null;
        try {
            proxyObject = proxyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return proxyObject;
    }

    public static <T extends InterceptorHandler> T getHandler(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((ProxyObject)proxyObject).getHandler();
        return (T)wrapper.handler;
    }

    public static <T extends InterceptorHandler> void setHandler(Object proxyObject, T handler) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((ProxyObject)proxyObject).getHandler();
        wrapper.handler = handler;
    }

    public static Class getTargetClass(Object proxyObject) {
        InterceptorHandlerWrapper wrapper = (InterceptorHandlerWrapper)((ProxyObject)proxyObject).getHandler();
        return wrapper.targetClass;
    }

    private static class InterceptorHandlerWrapper
    implements MethodHandler {
        InterceptorHandler handler;
        Object instance;
        Class targetClass;

        public InterceptorHandlerWrapper(Object instance, InterceptorHandler handler) {
            this.handler = handler;
            this.instance = instance;
            if (instance != null) {
                this.targetClass = instance.getClass();
            }
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            return this.handler.invoke(self, thisMethod, this.instance, proceed, args);
        }
    }
}

