/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.e6tech.elements.common.logging.TimedLogger;
import net.e6tech.elements.common.resources.AlreadyBoundException;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.ResourceManager;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;

class ResourcesState {
    private InjectionModule module;
    private Injector injector;
    private boolean opened = false;
    private boolean aborted = false;
    private boolean committed = false;
    private boolean dirty = false;
    private Map<String, Object> configuration = new LinkedHashMap<String, Object>();
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private LinkedList<Object> injectionList = new LinkedList();
    private List<Module> modules;
    private boolean useChildInjector = false;
    private Map<String, Object> context = new LinkedHashMap<String, Object>();

    ResourcesState() {
        this.module = new InjectionModule();
    }

    protected void cleanup() {
        this.modules = null;
        this.module = new InjectionModule();
        this.context.clear();
        this.resourceProviders.clear();
        this.opened = false;
        this.aborted = false;
        this.dirty = false;
    }

    void discard() {
        this.module = null;
        this.context = null;
        this.resourceProviders = null;
    }

    public InjectionModule getModule() {
        return this.module;
    }

    public void setModule(InjectionModule module) {
        this.module = module;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public void setResourceProviders(List<ResourceProvider> resourceProviders) {
        this.resourceProviders = resourceProviders;
    }

    public LinkedList<Object> getInjectionList() {
        return this.injectionList;
    }

    public void setInjectionList(LinkedList<Object> injectionList) {
        this.injectionList = injectionList;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void addModule(InjectionModule module) {
        this.module.add(module);
        this.setDirty(true);
    }

    public void initModules(Resources resources) {
        if (!this.useChildInjector && this.getModules() == null) {
            this.modules = new ArrayList<Module>();
            this.modules.add((Module)this.getModule());
            if (resources.getResourceManager() != null) {
                this.modules.add((Module)resources.getResourceManager().getModule());
            }
        }
        TimedLogger timed = new TimedLogger();
        this.injector = this.useChildInjector ? resources.getResourceManager().getInjector().createChildInjector(new Module[]{this.getModule()}) : Guice.createInjector(this.modules);
        timed.log();
        this.setDirty(false);
        while (this.injectionList.size() > 0) {
            Object obj = this.injectionList.remove();
            this._inject(resources, this.injector, obj);
        }
    }

    public <T> T tryBind(Resources resources, Class<T> cls, Callable<T> callable) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            return o;
        }
        if (this.useChildInjector && (o = resources.getResourceManager().getModule().getBoundInstance(cls)) != null) {
            return o;
        }
        Object instance = null;
        try {
            instance = this.getModule().bindInstance(cls, callable.call());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T bind(Resources resources, Class<T> cls, T resource) {
        T o = this.getModule().getBoundInstance(cls);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        if (this.useChildInjector && (o = resources.getResourceManager().getModule().getBoundInstance(cls)) != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound in ResourceManager to " + o);
        }
        Object instance = this.getModule().bindInstance(cls, resource);
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T rebind(Resources resources, Class<T> cls, T resource) {
        Object instance = null;
        if (this.useChildInjector) {
            resources.getResourceManager().getModule().getBoundInstance(cls);
            if (instance != null) {
                throw new AlreadyBoundException("Class " + cls + " is already bound in ResourceManager to " + instance);
            }
        }
        try {
            instance = this.getModule().bindInstance(cls, resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T unbind(Class<T> cls) {
        Object instance = null;
        try {
            instance = this.getModule().unbindInstance(cls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setDirty(true);
        return (T)instance;
    }

    public void bindClass(Class cls, Class service) {
        Class c = this.getModule().getBoundClass(cls);
        if (c != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + c);
        }
        if (service != null) {
            this.getModule().bindClass(cls, service);
        } else {
            this.getModule().bindInstance(cls, null);
        }
        this.setDirty(true);
    }

    public <T> T bindNamedInstance(String name, Class<T> cls, T resource) {
        Object o = this.getModule().getBoundNamedInstance(name);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        return this.rebindNamedInstance(name, cls, resource);
    }

    public <T> T rebindNamedInstance(String name, Class<T> cls, T resource) {
        Object instance = this.getModule().bindNamedInstance(name, cls, resource);
        this.setDirty(true);
        return (T)instance;
    }

    public <T> T inject(Resources resources, T object) {
        if (this.isDirty()) {
            this.injectionList.add(object);
            resources.onOpen();
        }
        if (this.injector != null) {
            this._inject(resources, this.injector, object);
        } else {
            this.injectionList.add(object);
        }
        return object;
    }

    protected void _inject(Resources resources, Injector injector, Object object) {
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).preInject(resources);
        }
        injector.injectMembers(object);
        if (object instanceof InjectionListener) {
            ((InjectionListener)object).injected(resources);
        }
    }

    public boolean hasInstance(Resources resources, Class cls) {
        if (cls.isAssignableFrom(Resources.class) || cls.isAssignableFrom(ResourceManager.class)) {
            return true;
        }
        if (this.getInjector() == null) {
            if (resources.getResourceManager().hasInstance(cls)) {
                return true;
            }
            return this.getModule().hasInstance(cls);
        }
        try {
            this.getInjector().getInstance(cls);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    public <T> T getInstance(Resources resources, Class<T> cls) throws InstanceNotFoundException {
        if (cls.isAssignableFrom(Resources.class)) {
            return (T)resources;
        }
        if (cls.isAssignableFrom(ResourceManager.class)) {
            return (T)resources.getResourceManager();
        }
        if (this.getInjector() == null) {
            if (!this.getModule().hasInstance(cls)) {
                throw new InstanceNotFoundException("No instance for class " + cls.getName() + " Use newInstance if you meant to create an instance");
            }
            return (T)this.getModule().getInstance(cls);
        }
        if (this.isDirty()) {
            resources.onOpen();
        }
        try {
            return (T)this.getInjector().getInstance(cls);
        }
        catch (ConfigurationException ex) {
            throw new InstanceNotFoundException("No instance for class " + cls.getName() + ". Use newInstance if you meant to create an instance", ex);
        }
    }
}

