/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.script.ScriptException;
import net.e6tech.elements.common.instance.InstanceFactory;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.logging.TimedLogger;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.AlreadyBoundException;
import net.e6tech.elements.common.resources.Atom;
import net.e6tech.elements.common.resources.BeanLifecycle;
import net.e6tech.elements.common.resources.InjectionListener;
import net.e6tech.elements.common.resources.InjectionModule;
import net.e6tech.elements.common.resources.InstanceNotFoundException;
import net.e6tech.elements.common.resources.Merge;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceManagerListener;
import net.e6tech.elements.common.resources.ResourcePool;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.plugin.Plugin;
import net.e6tech.elements.common.script.AbstractScriptShell;
import net.e6tech.elements.common.util.monitor.AllocationMonitor;
import org.apache.logging.log4j.ThreadContext;

public class ResourceManager
extends AbstractScriptShell
implements ResourcePool {
    private static Logger logger = Logger.getLogger();
    private String name;
    private Injector injector;
    private InjectionModule module = new InjectionModule();
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private AllocationMonitor allocation = new AllocationMonitor();
    private Map<String, ResourceManager> resourceManagers;
    private Map<String, Atom> atoms = new LinkedHashMap<String, Atom>();
    private NotificationCenter notificationCenter = new NotificationCenter();
    private BeanLifecycle beanLifecycle = new BeanLifecycle();
    private Plugin plugin = new Plugin(this);
    private List<ResourceManagerListener> listeners = new LinkedList<ResourceManagerListener>();

    public ResourceManager() {
        this(new Properties());
    }

    public ResourceManager(Provision provision) {
        this.initialize(this.plugin.getPluginClassLoader(), provision.getProperties());
        this._initialize(provision.getProperties());
        Object myProvision = this.loadProvision(provision.getClass());
        ((Provision)myProvision).load(provision.getResourceManager().getScripting().getVariables());
    }

    public ResourceManager(Properties properties) {
        this.initialize(this.plugin.getPluginClassLoader(), ResourceManager.updateProperties(properties));
        this._initialize(properties);
    }

    private void _initialize(Properties properties) {
        String logDir = properties.getProperty("logDir");
        if (logDir != null) {
            ThreadContext.put((String)"logDir", (String)logDir);
        } else {
            logDir = properties.getProperty("elements.common.logging.logDir");
            if (logDir != null) {
                ThreadContext.put((String)"logDir", (String)logDir);
            }
        }
        this.name = properties.getProperty("name");
        InstanceFactory instanceFactory = new InstanceFactory();
        this.module.bindInstance(ResourceManager.class, this);
        this.module.bindInstance(NotificationCenter.class, this.notificationCenter);
        this.module.bindInstance(Interceptor.class, Interceptor.getInstance());
        this.module.bindInstance(InstanceFactory.class, instanceFactory);
        this.module.bindInstance(Plugin.class, this.plugin);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.getScripting().put("notificationCenter", this.notificationCenter);
        this.getScripting().put("interceptor", Interceptor.getInstance());
        this.getScripting().put("instanceFactory", instanceFactory);
        this.getScripting().put("plugin", this.plugin);
        Thread.currentThread().setContextClassLoader(this.plugin.getPluginClassLoader());
    }

    public void addListener(ResourceManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ResourceManagerListener listener) {
        this.listeners.remove(listener);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    private static Properties updateProperties(Properties properties) {
        if (properties.getProperty("home") != null) {
            String home = properties.getProperty("home");
            String name = properties.getProperty("name");
            if (name == null) {
                try {
                    name = Paths.get(new File(home).getCanonicalPath(), new String[0]).getFileName().toString();
                    properties.setProperty("name", name);
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid home location " + home);
                }
            }
            properties.setProperty(name, home);
        }
        return properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            this.getScripting().remove(this.name);
        }
        this.name = name;
        this.getScripting().put(name, this.getProperties().getProperty("home"));
    }

    public Map<String, ResourceManager> getResourceManagers() {
        return this.resourceManagers;
    }

    public void setResourceManagers(Map<String, ResourceManager> resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    public ResourceManager getResourceManager(String name) {
        return this.resourceManagers.get(name);
    }

    public AllocationMonitor getAllocationMonitor() {
        return this.allocation;
    }

    public void onLaunched() {
        this.getScripting().onLaunched();
        super.onLoaded();
        this.beanLifecycle.clearBeanListeners();
    }

    @Override
    protected void onLoaded() {
    }

    public <T> T getAtomResource(String atomName, String resourceName) {
        return (T)this.getAtoms().get(atomName).get(resourceName);
    }

    public Map<String, Atom> getAtoms() {
        return Collections.unmodifiableMap(this.atoms);
    }

    public Atom createAtom(Consumer<Atom> consumer) {
        return this.createAtom(null, consumer);
    }

    public Atom createAtom(String atomName, Consumer<Atom> consumer) {
        if (this.name != null && this.atoms.get(atomName) != null) {
            return this.atoms.get(atomName);
        }
        Atom atom = new Atom(this);
        atom.setName(atomName);
        if (atomName == null) {
            logger.warn("Atom name is null", new Throwable());
        } else {
            this.atoms.put(atomName, atom);
        }
        consumer.accept(atom);
        TimedLogger timed = new TimedLogger(0L);
        Atom comp = atom.build();
        timed.log("Atom " + atomName);
        return comp;
    }

    public <T extends Provision> T loadProvision(Class<? extends Provision> clazz) {
        Class<? extends Provision> cls = clazz;
        Provision provision = null;
        try {
            provision = cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean alreadyBound = false;
        while (Provision.class.isAssignableFrom(cls)) {
            try {
                this.bind(cls, provision);
            }
            catch (AlreadyBoundException ex) {
                alreadyBound = true;
            }
            cls = cls.getSuperclass();
        }
        if (alreadyBound) {
            return (T)this.getInstance(Provision.class);
        }
        provision.load(this.getScripting().getVariables());
        this.getScripting().put("provision", provision);
        Provision p = provision;
        this.listeners.forEach(l -> l.provisionLoaded(p));
        return (T)provision;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    public boolean hasInstance(Class clazz) {
        if (Provision.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            this.injector.getInstance(clazz);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    public <T> T getInstance(Class<T> clazz) throws InstanceNotFoundException {
        try {
            return (T)this.injector.getInstance(clazz);
        }
        catch (ConfigurationException ex) {
            if (Provision.class.isAssignableFrom(clazz)) {
                return this.loadProvision(clazz);
            }
            throw new InstanceNotFoundException("No instance for class " + clazz.getName(), ex);
        }
    }

    @Override
    public <T> T bind(Class<T> cls, T resource) {
        T o = this.module.getBoundInstance(cls);
        if (o != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + o);
        }
        this.module.bindInstance(cls, resource);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        Object instance = this.getInstance(cls);
        this.listeners.forEach(l -> l.bound(cls, instance));
        return instance;
    }

    @Override
    public <T> T rebind(Class<T> cls, T resource) {
        this.module.bindInstance(cls, resource);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        Object instance = this.getInstance(cls);
        this.listeners.forEach(l -> l.bound(cls, instance));
        return instance;
    }

    @Override
    public <T> T unbind(Class<T> cls) {
        Object instance = this.module.unbindInstance(cls);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.listeners.forEach(l -> l.unbound(cls, instance));
        return (T)instance;
    }

    public void tryBindClass(Class cls, Class service) {
        try {
            this.bindClass(cls, service);
        }
        catch (AlreadyBoundException alreadyBoundException) {
            // empty catch block
        }
    }

    @Override
    public void bindClass(Class cls, Class service) {
        Class c = this.module.getBoundClass(cls);
        if (c != null) {
            throw new AlreadyBoundException("Class " + cls + " is already bound to " + c);
        }
        if (service != null) {
            this.module.bindClass(cls, service);
        } else {
            this.module.bindInstance(cls, null);
        }
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        if (service != null) {
            this.listeners.forEach(l -> l.classBound(cls, service));
        } else {
            this.listeners.forEach(l -> l.classBound(cls, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T bindNamedInstance(String name, Class<T> a, T b) {
        Object instance = this.module.getBoundNamedInstance(name);
        if (instance != null) {
            Class<?> argType = null;
            if (b != null) {
                argType = b.getClass();
            }
            Method found = this.getMergeMethod(instance.getClass(), argType);
            Object merged = null;
            if (found != null) {
                try {
                    merged = found.invoke(instance, b);
                }
                catch (Throwable throwable) {}
            } else if (b != null) {
                found = this.getMergeMethod(b.getClass(), instance.getClass());
                try {
                    merged = found.invoke(instance, b);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (merged == null) throw new AlreadyBoundException("Instance named " + name + " is already bound to " + instance);
            this.module.bindNamedInstance(name, a, b);
            this.injector = Guice.createInjector((Module[])new Module[]{this.module});
            this.listeners.forEach(l -> l.namedInstanceBound(name, a, b));
            return instance;
        }
        this.module.bindNamedInstance(name, a, b);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.listeners.forEach(l -> l.namedInstanceBound(name, a, b));
        return instance;
    }

    @Override
    public <T> T rebindNamedInstance(String name, Class<T> cls, T resource) {
        Object instance = this.module.bindNamedInstance(name, cls, resource);
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.listeners.forEach(l -> l.namedInstanceBound(name, cls, instance));
        return (T)instance;
    }

    private Method getMergeMethod(Class cls, Class argType) {
        Method found = null;
        while (found == null && !cls.equals(Object.class)) {
            Method[] methods;
            for (Method m : methods = cls.getDeclaredMethods()) {
                if (m.getAnnotation(Merge.class) == null || m.getParameterCount() != 1 || m.getReturnType().equals(Void.class)) continue;
                if (argType == null) {
                    found = m;
                    break;
                }
                Class<?> paramType = m.getParameterTypes()[0];
                if (!paramType.isAssignableFrom(argType)) continue;
                found = m;
                break;
            }
            cls = cls.getSuperclass();
        }
        return found;
    }

    @Override
    public <T> T inject(T obj) {
        if (obj instanceof InjectionListener) {
            ((InjectionListener)obj).preInject(this);
        }
        this.injector.injectMembers(obj);
        if (obj instanceof InjectionListener) {
            ((InjectionListener)obj).injected(this);
        }
        this.listeners.forEach(l -> l.injected(obj));
        return obj;
    }

    public BeanLifecycle getBeanLifecycle() {
        return this.beanLifecycle;
    }

    public <T> T registerBean(String name, Object instance) {
        Object obj = instance;
        if (instance instanceof Class) {
            obj = this.newInstance((Class)instance);
        } else {
            this.inject(obj);
        }
        return this.addBean(name, obj);
    }

    protected <T> T addBean(String name, Object instance) {
        if (this.getScripting().getVariables().get(name) != null) {
            throw logger.runtimeException("bean with name=" + name + " already registered");
        }
        try {
            Method method = instance.getClass().getMethod("setName", String.class);
            method.invoke(instance, name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getScripting().put(name, instance);
        this.listeners.forEach(l -> l.beanAdded(name, instance));
        return (T)instance;
    }

    public void unregisterBean(String name) {
        Object instance = this.getScripting().remove(name);
        this.listeners.forEach(l -> l.beanRemoved(name, instance));
    }

    @Override
    public <T> T getBean(String name) {
        return (T)this.getScripting().getVariables().get(name);
    }

    @Override
    public <T> T getBean(Class<T> cls) {
        Object value = null;
        Map<String, Object> variables = this.getScripting().getVariables();
        for (String key : variables.keySet()) {
            Object obj = variables.get(key);
            if (obj == null || !cls.isAssignableFrom(obj.getClass())) continue;
            if (value != null) {
                throw new RuntimeException("Multiple objects can be assigned to " + cls);
            }
            value = obj;
        }
        return (T)value;
    }

    public Map<String, Object> getBeans() {
        return this.getBeans(null);
    }

    public Map<String, Object> getBeans(Class cls) {
        HashMap map = new HashMap();
        this.getScripting().getVariables().forEach((key, value) -> {
            if (cls == null || value != null && cls.isAssignableFrom(value.getClass())) {
                map.put(key, value);
            }
        });
        return Collections.unmodifiableMap(map);
    }

    public List listBeans() {
        Map<String, Object> variables = this.getScripting().getVariables();
        ArrayList list = new ArrayList(variables.size());
        variables.values().forEach(b -> list.add(b));
        return Collections.unmodifiableList(list);
    }

    public InjectionModule getModule() {
        return this.module;
    }

    @Override
    public synchronized void load(String str) throws ScriptException {
        this.load(str, true);
    }

    public synchronized void load(String str, boolean logInfo) throws ScriptException {
        long start = System.currentTimeMillis();
        super.load(str);
        if (logInfo) {
            int len = 0;
            LinkedList<String> atomString = new LinkedList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("    ");
            int count = this.atoms.size();
            int i = 1;
            for (String atomName : this.atoms.keySet()) {
                String msg;
                builder.append(atomName);
                if (i != count) {
                    builder.append(", ");
                }
                if (i % 5 == 0) {
                    msg = builder.toString();
                    if (len < msg.length()) {
                        len = msg.length();
                    }
                    atomString.add(builder.toString());
                    builder.setLength(0);
                    builder.append("    ");
                } else if (i == count) {
                    msg = builder.toString();
                    if (len < msg.length()) {
                        len = msg.length();
                    }
                    atomString.add(builder.toString());
                }
                ++i;
            }
            String message = "Done processing " + str;
            String message2 = "ResourceManager " + this.name + " loaded in " + (System.currentTimeMillis() - start) + "ms";
            if (message.length() > len) {
                len = message.length();
            }
            if (message2.length() > len) {
                len = message2.length();
            }
            char[] line = new char[len];
            Arrays.fill(line, '*');
            logger.info(new String(line));
            logger.info(message);
            logger.info(message2);
            logger.info("Loaded atoms:");
            for (String msg : atomString) {
                logger.info(msg);
            }
            logger.info(new String(line));
        }
    }

    public <Res extends Resources> Res open() {
        return (Res)this.open(resources -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Res extends Resources> Res open(Consumer<Res> preOpen) {
        Object resources = this.newResources();
        this.inject(resources);
        if (preOpen != null) {
            ((Resources)resources).setPreOpen(preOpen);
            preOpen.accept(resources);
        }
        List<ResourceProvider> list = this.resourceProviders;
        synchronized (list) {
            for (ResourceProvider p : this.resourceProviders) {
                p.onOpen((Resources)resources);
            }
        }
        ((Resources)resources).onOpen();
        return (Res)resources;
    }

    protected void addResourceProvider(ResourceProvider p) {
        this.inject(p);
        this.resourceProviders.add(p);
        this.listeners.forEach(l -> l.resourceProviderAdded(p));
    }

    protected List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    protected void setResourceProviders(List<ResourceProvider> resourceProviders) {
        this.resourceProviders = resourceProviders;
    }

    public <T extends Resources> T newResources() {
        Provision provision = this.getInstance(Provision.class);
        return (T)this.newInstance(provision.getResourcesClass());
    }
}

