/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.resources;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.e6tech.elements.common.resources.BeanListener;

public class BeanLifecycle {
    private static final int BEAN_INITIALIZED = 0;
    private static final int BEAN_STARTED = 1;
    private static final int BEAN_LAUNCHED = 2;
    private Map<String, Object> initializedBeans = new Hashtable<String, Object>();
    private Map<String, List<BeanListener>> namedBeanListeners = new Hashtable<String, List<BeanListener>>();
    private Map<Class, List<BeanListener>> classBeanListeners = new Hashtable<Class, List<BeanListener>>();

    public void addBeanListener(String name, BeanListener beanListener) {
        if (this.initializedBeans.get(name) != null) {
            beanListener.initialized(this.initializedBeans.get(name));
            return;
        }
        List listeners = this.namedBeanListeners.computeIfAbsent(name, n -> new Vector());
        listeners.add(beanListener);
    }

    public void addBeanListener(Class cls, BeanListener beanListener) {
        for (Object bean : this.initializedBeans.values()) {
            if (!cls.isAssignableFrom(bean.getClass())) continue;
            beanListener.initialized(bean);
        }
        List listeners = this.classBeanListeners.computeIfAbsent(cls, n -> new Vector());
        listeners.add(beanListener);
    }

    public void removeBeanListener(BeanListener listener) {
        for (List<BeanListener> listeners : this.namedBeanListeners.values()) {
            listeners.remove(listener);
        }
        for (List<BeanListener> listeners : this.classBeanListeners.values()) {
            listeners.remove(listener);
        }
    }

    public void fireBeanInitialized(String beanName, Object bean) {
        this.fireBeanEvent(beanName, bean, 0);
        this.initializedBeans.put(beanName, bean);
    }

    public void fireBeanStarted(String beanName, Object bean) {
        this.fireBeanEvent(beanName, bean, 1);
    }

    public void fireBeanLaunched(String beanName, Object bean) {
        this.fireBeanEvent(beanName, bean, 2);
    }

    public void clearBeanListeners() {
        this.initializedBeans.clear();
        this.namedBeanListeners.clear();
        this.classBeanListeners.clear();
    }

    private void fireBeanEvent(String beanName, Object bean, int eventType) {
        ArrayList<BeanListener> list = null;
        if (beanName != null) {
            list = new ArrayList<BeanListener>();
            List<BeanListener> listeners = this.namedBeanListeners.get(beanName);
            if (listeners != null) {
                list.addAll(listeners);
            }
        }
        for (Class cls : this.classBeanListeners.keySet()) {
            List<BeanListener> listeners;
            if (list == null) {
                list = new ArrayList();
            }
            if (!cls.isAssignableFrom(bean.getClass()) || (listeners = this.classBeanListeners.get(cls)) == null) continue;
            list.addAll(listeners);
        }
        if (list != null) {
            list.forEach(beanListener -> this.notifyBeanListener((BeanListener)beanListener, bean, eventType));
        }
    }

    private void notifyBeanListener(BeanListener beanListener, Object bean, int eventType) {
        switch (eventType) {
            case 0: {
                beanListener.initialized(bean);
                break;
            }
            case 1: {
                beanListener.started(bean);
                break;
            }
            case 2: {
                beanListener.launched(bean);
            }
        }
    }
}

