/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.common.instance;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.ProxyObject;
import net.e6tech.elements.common.instance.Delegate;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.serialization.ObjectFinder;
import net.e6tech.elements.common.serialization.ObjectLocator;
import net.e6tech.elements.common.serialization.ObjectReference;

public class Instance {
    Interceptor interceptor;
    Class implementationClass;
    Class proxyClass;
    List<Field> delegateFields;
    Map<Field, Instance> children = new LinkedHashMap<Field, Instance>();
    List<Class> searchOrder = new LinkedList<Class>();

    public static List<Field> getDelegateFields(Class cls) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                if (f.getAnnotation(Delegate.class) == null) continue;
                f.setAccessible(true);
                fieldList.add(f);
            }
        }
        return fieldList;
    }

    public <T> T newInstance(Resources resources, Object ... delegates) {
        References references = new References();
        Handler handler = new Handler(resources, this.searchOrder);
        if (delegates != null) {
            for (Object obj : delegates) {
                references.put(obj.getClass(), obj);
            }
        }
        return (T)this.createInstance(resources, null, handler, references);
    }

    public Instance(Class cls, Interceptor interceptor) {
        this.implementationClass = cls;
        this.interceptor = interceptor;
        HashSet seen = new HashSet();
        LinkedList list = new LinkedList();
        list.add(cls);
        while (list.size() > 0) {
            Class c = (Class)list.remove();
            this.searchOrder.add(c);
            List<Field> fields = Instance.getDelegateFields(c);
            for (Field f : fields) {
                if (seen.contains(f.getType())) continue;
                seen.add(f.getType());
                list.add(f.getType());
            }
        }
        if (Modifier.isAbstract(this.implementationClass.getModifiers()) && !Modifier.isInterface(this.implementationClass.getModifiers())) {
            this.proxyClass = interceptor.createClass(this.implementationClass);
            this.delegateFields = Instance.getDelegateFields(this.proxyClass);
        } else {
            this.delegateFields = Instance.getDelegateFields(this.implementationClass);
        }
        this.delegateFields.forEach(field -> {
            field.setAccessible(true);
            Instance child = new Instance(field.getType(), interceptor);
            this.children.put((Field)field, child);
        });
    }

    public List<Field> getDelegateFields() {
        return this.delegateFields;
    }

    public Object createInstance(Resources resources, ObjectLocator locator, String methodName, Class[] parameterTypes) {
        References references = new References();
        Handler handler = new Handler(resources, this.searchOrder);
        Object obj = this.createInstance(resources, locator, handler, references);
        if (methodName != null && !(obj instanceof ProxyObject)) {
            obj = handler.findImplementor(methodName, parameterTypes);
        }
        return obj;
    }

    protected Object createInstance(Resources resources, ObjectLocator locator, Handler handler, References references) {
        Object instance = null;
        if (references.get(this.implementationClass) != null) {
            instance = references.get(this.implementationClass);
        } else if (locator != null && locator.findObjectReference(this.implementationClass) != null) {
            ObjectReference ref = locator.findObjectReference(this.implementationClass);
            ObjectFinder finder = resources.getInstance(ObjectFinder.class);
            instance = finder.toObject(resources, ref);
            references.put(this.implementationClass, instance);
        } else if (this.proxyClass != null) {
            try {
                instance = this.interceptor.newInstance(this.implementationClass, handler);
                for (Field field : this.children.keySet()) {
                    field.set(instance, this.children.get(field).createInstance(resources, locator, handler, references));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ObjectFinder finder = resources.getInstance(ObjectFinder.class);
            if (!finder.hasObjectReference(resources, this.implementationClass)) {
                instance = resources.newInstance(this.implementationClass);
            }
        }
        if (instance != null) {
            for (Field field : this.children.keySet()) {
                try {
                    field.set(instance, this.children.get(field).createInstance(resources, locator, handler, references));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            handler.add(this.implementationClass, instance);
        }
        return instance;
    }

    private static class References {
        private Map<String, Map<String, Object>> references = new LinkedHashMap<String, Map<String, Object>>();

        private References() {
        }

        public void put(Class cls, Object reference) {
            String packageName = cls.getPackage().getName();
            Map pack = this.references.computeIfAbsent(packageName, key -> new LinkedHashMap());
            pack.put(cls.getSimpleName(), reference);
        }

        public Object get(Class cls) {
            String packageName = cls.getPackage().getName();
            Map<String, Object> pack = this.references.get(packageName);
            Object reference = null;
            if (pack != null) {
                reference = pack.get(cls.getSimpleName());
            }
            if (reference != null) {
                return reference;
            }
            for (Map<String, Object> p : this.references.values()) {
                for (Object obj : p.values()) {
                    if (obj == null || !cls.isAssignableFrom(obj.getClass())) continue;
                    return obj;
                }
            }
            return null;
        }
    }

    private static class Handler
    implements InterceptorHandler {
        transient Map<Class, Object> implementations = new HashMap<Class, Object>();
        transient List<Class> classes = new LinkedList<Class>();

        public Handler(Resources resources, List<Class> list) {
            this.classes = list;
        }

        public void add(Class cl, Object obj) {
            this.implementations.put(cl, obj);
        }

        public Object get(Class cl) {
            return this.implementations.get(cl);
        }

        @Override
        public Object invoke(Object proxy, Method thisMethod, Object instance, Method proceed, Object[] args) throws Throwable {
            if (proceed == null) {
                Object obj = this.findImplementor(thisMethod.getName(), thisMethod.getParameterTypes());
                if (obj != null) {
                    Method m = obj.getClass().getMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                    return m.invoke(obj, args);
                }
                return null;
            }
            return proceed.invoke(proxy, args);
        }

        public Object findImplementor(String methodName, Class[] parameterTypes) {
            for (Class cl : this.classes) {
                try {
                    Object obj;
                    Method m = cl.getMethod(methodName, parameterTypes);
                    if (m == null || Modifier.isAbstract(m.getModifiers()) || (obj = this.implementations.get(cl)) == null) continue;
                    return obj;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                }
            }
            return null;
        }
    }
}

