/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.util.LinkedList;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.util.StringUtil;

public class AbstractGenerator {
    protected Generator generator;
    private String keyspace;
    private String tableName;
    private String tableKeyspace;
    private String tableCompression;

    AbstractGenerator(Generator generator) {
        this.generator = generator;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableKeyspace() {
        return this.tableKeyspace;
    }

    public String getTableCompression() {
        return this.tableCompression;
    }

    protected LinkedList<Class> analyze(Class entityClass) throws IntrospectionException {
        if (entityClass == null) {
            return new LinkedList<Class>();
        }
        LinkedList<Class> classHierarchy = new LinkedList<Class>();
        for (Class tmp = entityClass; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (this.generator.tableAnnotation(tmp) != null) {
                if (this.tableName == null) {
                    this.tableName = this.generator.tableName(tmp);
                }
                if (this.tableKeyspace == null) {
                    this.tableKeyspace = this.generator.tableKeyspace(tmp);
                }
                if (this.tableCompression == null) {
                    this.tableCompression = this.generator.tableCompression(tmp);
                }
            }
            classHierarchy.addFirst(tmp);
        }
        if (this.tableName == null) {
            throw new IntrospectionException("Class " + entityClass.getName() + " is not annotated with @Table");
        }
        return classHierarchy;
    }

    public String fullyQualifiedTableName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtil.isNullOrEmpty((String)this.getTableKeyspace())) {
            builder.append(this.getTableKeyspace()).append(".");
        } else if (!StringUtil.isNullOrEmpty((String)this.getKeyspace())) {
            builder.append(this.getKeyspace()).append(".");
        }
        builder.append(this.getTableName());
        return builder.toString();
    }
}

