/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.e6tech.elements.cassandra.driver.cql.Prepared;
import net.e6tech.elements.cassandra.etl.ETLContext;
import net.e6tech.elements.cassandra.etl.Partition;
import net.e6tech.elements.cassandra.etl.PartitionStrategy;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;

public class PartitionContext
extends ETLContext {
    private List<Comparable<?>> partitions = new ArrayList();
    private Map<String, Prepared> preparedStatements = new HashMap<String, Prepared>();
    private ToIntFunction<List<?>> loadDelegate;

    public static PartitionContext createContext(Provision provision, Class<? extends Partition> cls) {
        Partition partition;
        try {
            partition = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        PartitionContext context = partition.createContext();
        context.setSourceClass(cls);
        if (provision != null) {
            provision.inject((Object)context);
            context.initialize();
        }
        return context;
    }

    public PartitionContext createContext(Class<? extends Partition> cls) {
        return PartitionContext.createContext(this.getProvision(), cls);
    }

    public List<Comparable<?>> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<Comparable<?>> partitions) {
        this.partitions = partitions;
    }

    public PartitionStrategy createStrategy() {
        return new PartitionStrategy();
    }

    public ToIntFunction<List<?>> getLoadDelegate() {
        return this.loadDelegate;
    }

    public void setLoadDelegate(ToIntFunction<List<?>> loadDelegate) {
        this.loadDelegate = loadDelegate;
    }

    public Map<String, Prepared> getPreparedStatements() {
        return this.preparedStatements;
    }

    @Override
    public void reset() {
        super.reset();
        this.partitions.clear();
        this.preparedStatements.clear();
    }

    public PartitionContext run(Class<? extends PartitionStrategy> cls) {
        try {
            PartitionStrategy strategy = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setImportedCount(strategy.run(this));
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
        return this;
    }
}

