/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.driver.Wrapper;
import net.e6tech.elements.cassandra.driver.v4.GeneratorV4;
import net.e6tech.elements.cassandra.driver.v4.MappingManager;
import net.e6tech.elements.cassandra.driver.v4.SessionV4;
import net.e6tech.elements.cassandra.driver.v4.SibylV4;
import net.e6tech.elements.cassandra.driver.v4.TableMetadataV4;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.TextBuilder;

public class SessionProviderV4
extends SessionProvider {
    private static Logger logger = Logger.getLogger();
    private Generator generator = new GeneratorV4();
    private CqlSession session;
    private Map<String, Object> driverOptions = new LinkedHashMap<String, Object>();
    private MappingManager mappingManager;
    private String namingConvention;
    private Function<CqlSessionBuilder, CqlSessionBuilder> sessionCustomizer;

    public String getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(String namingConvention) {
        this.namingConvention = namingConvention;
    }

    public Map<String, Object> getDriverOptions() {
        return this.driverOptions;
    }

    public void setDriverOptions(Map<String, Object> driverOptions) {
        this.driverOptions = driverOptions;
    }

    public Function<CqlSessionBuilder, CqlSessionBuilder> getSessionCustomizer() {
        return this.sessionCustomizer;
    }

    public void setSessionCustomizer(Function<CqlSessionBuilder, CqlSessionBuilder> customizer) {
        this.sessionCustomizer = customizer;
    }

    @Override
    public net.e6tech.elements.cassandra.driver.metadata.TableMetadata getTableMetadata(String keyspaceIn, String tableName) {
        KeyspaceMetadata keyspaceMetadata = this.session.getMetadata().getKeyspace(this.getKeyspace(keyspaceIn)).orElse(null);
        if (keyspaceMetadata == null) {
            return null;
        }
        TableMetadata tableMetadata = keyspaceMetadata.getTable(tableName).orElse(null);
        return tableMetadata == null ? null : new TableMetadataV4(this.generator, tableMetadata);
    }

    @Override
    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    protected Session createSession(String keyspaceIn) {
        return Wrapper.wrap(new SessionV4(), this.session);
    }

    @Override
    protected void initGenerator() {
        GeneratorV4 gen = new GeneratorV4();
        if (this.getNamingConvention() != null) {
            gen.setNamingConvention(NamingConvention.valueOf((String)this.getNamingConvention()));
        }
        this.generator = gen;
    }

    @Override
    protected void initDriver() {
        if (this.session != null) {
            return;
        }
        ProgrammaticDriverConfigLoaderBuilder configBuilder = DriverConfigLoader.programmaticBuilder();
        for (Map.Entry<String, Object> entry : this.driverOptions.entrySet()) {
            configBuilder.withString((DriverOption)DefaultDriverOption.valueOf((String)entry.getKey()), "" + entry.getValue());
        }
        if (this.driverOptions.get("LOAD_BALANCING_POLICY_CLASS") == null) {
            configBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, DefaultLoadBalancingPolicy.class.getName());
        }
        DriverConfigLoader loader = configBuilder.build();
        CqlSessionBuilder builder = (CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(loader)).addContactPoint(new InetSocketAddress(this.getHost(), this.getPort()));
        try {
            this.session = this.getSession(builder, this.getKeyspace());
        }
        catch (InvalidKeyspaceException ex) {
            this.session = this.getSession(builder, null);
            this.createKeyspaceArguments.put("keyspace", this.getKeyspace());
            this.session.execute(TextBuilder.using((String)this.createKeyspace).build(this.createKeyspaceArguments));
            this.session.close();
            this.session = this.getSession(builder, this.getKeyspace());
        }
        catch (AllNodesFailedException ex) {
            logger.error("No Cassandra server found at address {}:{}", (Object)this.getHost(), (Object)this.getPort());
            throw ex;
        }
        this.mappingManager = new MappingManager(this, this.session, this.getKeyspace());
    }

    private CqlSession getSession(CqlSessionBuilder builder, String keyspace) {
        CqlSessionBuilder b = (CqlSessionBuilder)builder.withKeyspace(keyspace);
        if (this.sessionCustomizer != null) {
            b = this.sessionCustomizer.apply(b);
        }
        return (CqlSession)b.build();
    }

    @Override
    protected void initKeyspace() {
    }

    @Override
    protected void postInit() {
    }

    public void onOpen(Resources resources) {
        resources.rebind(Session.class, (Object)Wrapper.wrap(new SessionV4(), this.session));
        resources.rebind(MappingManager.class, (Object)this.mappingManager);
        resources.rebind(SessionProvider.class, (Object)this);
        Sibyl s = (Sibyl)resources.newInstance(SibylV4.class);
        s.setReadOptions(this.getDefaultReadOptions());
        s.setWriteOptions(this.getDefaultWriteOptions());
        resources.rebind(Sibyl.class, (Object)s);
    }

    public void onClosed(Resources resources) {
    }

    public void onShutdown() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

