/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.query.BaseQuery;

public class LimitQuery<T>
extends BaseQuery<T, LimitQuery<T>> {
    private boolean subQuery;
    protected List<BaseQuery.Relation> lastOrderBy = new ArrayList<BaseQuery.Relation>();

    public LimitQuery(Sibyl sibyl, Class<T> entityClass) {
        super(sibyl, entityClass);
    }

    public LimitQuery<T> previous(T last) {
        for (BaseQuery.Relation r : this.orderBy) {
            BaseQuery.Relation relation = new BaseQuery.Relation(this, r.keyColumn, r.comparison, r.accessor.get(last));
            this.lastOrderBy.removeIf(o -> o.keyColumn.getPosition() == relation.keyColumn.getPosition());
            this.lastOrderBy.add(relation);
            for (BaseQuery.Relation r2 : this.clusteringRelations) {
                if (r.keyColumn.getPosition() != r2.keyColumn.getPosition() || (r.comparison != BaseQuery.Comparison.LESS_THAN || r2.comparison != BaseQuery.Comparison.GREATER_THAN_OR_EQUAL) && (r.comparison != BaseQuery.Comparison.GREATER_THAN || r2.comparison != BaseQuery.Comparison.LESS_THAN_OR_EQUAL)) continue;
                r2.value = relation.value;
            }
        }
        return this;
    }

    public List<T> query() {
        this.validate();
        this.lastOrderBy.sort(Comparator.comparingInt(c -> c.keyColumn.getPosition()));
        this.validateLastOrderBy();
        List duplicates = Collections.emptyList();
        if (!this.subQuery && !this.lastOrderBy.isEmpty() && this.limit > 0) {
            duplicates = this.subQuery().query();
        }
        int tmp = this.limit;
        if (this.limit > 0) {
            this.limit += duplicates.size();
        }
        List list = this.select();
        this.removeDuplicate(list, duplicates);
        this.limit = tmp;
        if (this.limit > 0 && list.size() > this.limit) {
            return list.subList(0, this.limit);
        }
        return list;
    }

    private void validateLastOrderBy() {
        if (this.lastOrderBy.isEmpty()) {
            return;
        }
        if (this.lastOrderBy.size() != this.orderBy.size()) {
            throw new IllegalStateException("Last order by size " + this.lastOrderBy.size() + " does not match order by size " + this.orderBy.size());
        }
        for (BaseQuery.Relation r : this.lastOrderBy) {
            boolean found = false;
            for (BaseQuery.Relation r2 : this.orderBy) {
                if (r.keyColumn.getPosition() != r2.keyColumn.getPosition()) continue;
                r.comparison = r2.comparison;
                r2.value = r.value;
                if (r2.value == null) {
                    throw new IllegalStateException("The value for last order by column " + r.keyColumn.getName() + " is null.");
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalStateException("Last order by column " + r.keyColumn.getName() + " not part of order by");
        }
    }

    private LimitQuery<T> subQuery() {
        BaseQuery.Relation r;
        LimitQuery<T> sub = new LimitQuery<T>(this.sibyl, this.entityClass);
        sub.subQuery = true;
        sub.partitionRelations = new ArrayList(this.partitionRelations);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.orderBy.size(); ++i) {
            BaseQuery.Relation o = (BaseQuery.Relation)this.orderBy.get(i);
            if (set.contains(o.keyColumn.getName())) continue;
            r = i == this.orderBy.size() - 1 ? (o.comparison == BaseQuery.Comparison.LESS_THAN ? new BaseQuery.Relation(this, o.keyColumn, BaseQuery.Comparison.LESS_THAN_OR_EQUAL, o.value) : new BaseQuery.Relation(this, o.keyColumn, BaseQuery.Comparison.GREATER_THAN_OR_EQUAL, o.value)) : new BaseQuery.Relation(this, o.keyColumn, BaseQuery.Comparison.EQUAL, o.value);
            sub.clusteringRelations.add(r);
            set.add(o.keyColumn.getName());
        }
        for (BaseQuery.Relation c : this.clusteringRelations) {
            if (set.contains(c.keyColumn.getName())) continue;
            r = new BaseQuery.Relation(this, c.keyColumn, BaseQuery.Comparison.EQUAL, c.value);
            sub.clusteringRelations.add(r);
            set.add(c.keyColumn.getName());
        }
        return sub;
    }

    private void removeDuplicate(List<T> list, List<T> duplicates) {
        block0: for (T t : duplicates) {
            Iterator<T> iterator = list.iterator();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                boolean same = true;
                for (BaseQuery.Relation relation : this.orderBy) {
                    if (relation.isRelated(t, t2)) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                iterator.remove();
                continue block0;
            }
        }
    }
}

