/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.query;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.generator.KeyColumn;
import net.e6tech.elements.cassandra.generator.TableGenerator;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.datastructure.Triplet;

public abstract class BaseQuery<T, Q extends BaseQuery<T, Q>> {
    protected static final String AND = " and ";
    protected Sibyl sibyl;
    protected T partitionTemplate;
    protected T clusteringTemplate;
    protected T orderByTemplate;
    protected RelationHandler partitionHandler;
    protected RelationHandler clusteringHandler;
    protected OrderByHandler orderByHandler;
    protected List<Relation> partitionRelations = new ArrayList<Relation>();
    protected List<Relation> orderBy = new ArrayList<Relation>();
    protected List<Relation> clusteringRelations = new ArrayList<Relation>();
    protected int limit = -1;
    protected Class<T> entityClass;
    protected TableGenerator table;
    protected Inspector inspector;

    public BaseQuery(Sibyl sibyl, Class<T> entityClass) {
        this.sibyl = sibyl;
        this.entityClass = entityClass;
        this.partitionHandler = new RelationHandler(true);
        this.clusteringHandler = new RelationHandler(false);
        this.orderByHandler = new OrderByHandler();
        this.partitionTemplate = Interceptor.getInstance().newInstance(entityClass, (InterceptorHandler)this.partitionHandler);
        this.clusteringTemplate = Interceptor.getInstance().newInstance(entityClass, (InterceptorHandler)this.clusteringHandler);
        this.orderByTemplate = Interceptor.getInstance().newInstance(entityClass, (InterceptorHandler)this.orderByHandler);
        this.table = sibyl.getGenerator().getTable(null, entityClass);
        this.inspector = sibyl.getInspector(entityClass);
    }

    public Q limit(int limit) {
        this.limit = limit;
        return (Q)this;
    }

    public int limit() {
        return this.limit;
    }

    protected <R> Q newRelation(BiConsumer<T, R> consumer, R value, Comparison comparison, List<Relation> list, boolean partition) {
        T template = partition ? this.partitionTemplate : this.clusteringTemplate;
        RelationHandler relationHandler = partition ? this.partitionHandler : this.clusteringHandler;
        consumer.accept(template, value);
        Relation relation = new Relation(relationHandler.keyColumn, comparison, value);
        list.removeIf(r -> r.comparison == comparison && r.keyColumn.getPosition() == relation.keyColumn.getPosition());
        list.add(relation);
        return (Q)this;
    }

    public <R> Q partition(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.EQUAL, this.partitionRelations, true);
    }

    public <R> Q equalTo(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.EQUAL, this.clusteringRelations, false);
    }

    protected Q newOrderBy(Consumer<T> consumer, Comparison comparison) {
        this.orderByHandler.keyColumnValues.clear();
        consumer.accept(this.orderByTemplate);
        for (KeyColumnValue keyColumnValue : this.orderByHandler.keyColumnValues) {
            KeyColumn keyColumn = keyColumnValue.keyColumn;
            Relation relation = new Relation(keyColumn, comparison, null);
            this.orderBy.removeIf(o -> o.keyColumn.getPosition() == relation.keyColumn.getPosition());
            this.orderBy.add(relation);
        }
        this.orderByHandler.keyColumnValues.clear();
        this.orderBy.forEach(o -> {
            o.comparison = comparison;
        });
        return (Q)this;
    }

    protected <R> Q lessThan(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.LESS_THAN, this.clusteringRelations, false);
    }

    protected <R> Q lessThanOrEqualTo(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.LESS_THAN_OR_EQUAL, this.clusteringRelations, false);
    }

    protected <R> Q greaterThan(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.GREATER_THAN, this.clusteringRelations, false);
    }

    protected <R> Q greaterThanOrEqualTo(BiConsumer<T, R> consumer, R value) {
        return this.newRelation(consumer, value, Comparison.GREATER_THAN_OR_EQUAL, this.clusteringRelations, false);
    }

    public <R extends Comparable<R>> Q ascending(BiConsumer<T, R> consumer, R from, R to) {
        if (from.compareTo(to) < 0) {
            this.greaterThan(consumer, from);
            this.lessThanOrEqualTo(consumer, to);
        } else {
            this.greaterThan(consumer, to);
            this.lessThanOrEqualTo(consumer, from);
        }
        return this.newOrderBy(t -> consumer.accept(t, from), Comparison.LESS_THAN);
    }

    public <R extends Comparable<R>> Q descending(BiConsumer<T, R> consumer, R from, R to) {
        if (from.compareTo(to) < 0) {
            this.lessThan(consumer, to);
            this.greaterThanOrEqualTo(consumer, from);
        } else {
            this.lessThan(consumer, from);
            this.greaterThanOrEqualTo(consumer, to);
        }
        return this.newOrderBy(t -> consumer.accept(t, from), Comparison.GREATER_THAN);
    }

    public Q ascending(Consumer<T> consumer) {
        return this.newOrderBy(consumer, Comparison.LESS_THAN);
    }

    public Q descending(Consumer<T> consumer) {
        return this.newOrderBy(consumer, Comparison.GREATER_THAN);
    }

    protected Q clearOrderBy() {
        return (Q)this;
    }

    protected void buildRelation(StringBuilder builder, Map<String, Object> map, Relation relation) {
        builder.append(relation.keyColumn.getName());
        switch (relation.comparison) {
            case EQUAL: {
                builder.append(" = ");
                break;
            }
            case LESS_THAN: {
                builder.append(" < ");
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                builder.append(" <= ");
                break;
            }
            case GREATER_THAN: {
                builder.append(" > ");
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                builder.append(" >= ");
            }
        }
        if (relation.value == null) {
            throw new IllegalArgumentException("comparision value for " + relation.keyColumn.getName() + " cannot be null");
        }
        String argument = relation.keyColumn.getName() + "_" + (map.size() + 1);
        builder.append(":").append(argument);
        map.put(argument, relation.value);
    }

    protected void buildPartitionKeys(StringBuilder builder, Map<String, Object> map) {
        boolean first = true;
        for (Relation relation : this.partitionRelations) {
            if (first) {
                first = false;
            } else {
                builder.append(AND);
            }
            this.buildRelation(builder, map, relation);
        }
    }

    protected void buildClusteringKeys(StringBuilder builder, Map<String, Object> map) {
        boolean first = true;
        for (Relation relation : this.clusteringRelations) {
            if (first) {
                first = false;
            } else {
                builder.append(AND);
            }
            this.buildRelation(builder, map, relation);
        }
    }

    protected void buildOrderBy(StringBuilder builder) {
        boolean first = true;
        for (Relation relation : this.orderBy) {
            if (first) {
                first = false;
                builder.append(" order by ");
            } else {
                builder.append(", ");
            }
            builder.append(relation.keyColumn.getName());
            if (relation.comparison == Comparison.LESS_THAN) {
                builder.append(" asc ");
                continue;
            }
            if (relation.comparison == Comparison.GREATER_THAN) {
                builder.append(" desc ");
                continue;
            }
            throw new IllegalStateException();
        }
    }

    protected void validate() {
        this.partitionRelations.sort(Comparator.comparingInt(c -> c.keyColumn.getPosition()));
        this.clusteringRelations.sort(Comparator.comparingInt(c -> c.keyColumn.getPosition()));
        this.orderBy.sort(Comparator.comparingInt(c -> c.keyColumn.getPosition()));
        this.validatePartitionKeys();
        this.validClusteringKeys();
    }

    protected List<T> select() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder query = this.buildQuery(map);
        return this.sibyl.all(this.entityClass, query.toString(), map);
    }

    protected StringBuilder buildQuery(Map<String, Object> map) {
        StringBuilder query = new StringBuilder("select * from ");
        query.append(this.table.getTableName()).append(" where ");
        this.buildPartitionKeys(query, map);
        if (!this.partitionRelations.isEmpty() && !this.clusteringRelations.isEmpty()) {
            query.append(AND);
        }
        this.buildClusteringKeys(query, map);
        this.buildOrderBy(query);
        if (this.limit > 0) {
            query.append(" ").append("limit ").append(this.limit);
        }
        return query;
    }

    protected void validatePartitionKeys() {
        for (KeyColumn key : this.table.getPartitionKeys()) {
            boolean found = false;
            for (Relation r : this.partitionRelations) {
                if (!r.keyColumn.getName().equals(key.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Partition key " + key.getName() + " not specified.");
        }
    }

    protected void validClusteringKeys() {
        Relation prev = null;
        for (Relation relation : this.clusteringRelations) {
            if (prev != null && prev.keyColumn.getPosition() != relation.keyColumn.getPosition() && prev.comparison != Comparison.EQUAL) {
                throw new IllegalArgumentException("Clustering key column " + prev.keyColumn.getName() + " comparison must be '='");
            }
            if (prev != null && prev.keyColumn.getPosition() != relation.keyColumn.getPosition() && relation.keyColumn.getPosition() - prev.keyColumn.getPosition() != 1) {
                throw new IllegalArgumentException("Missing relation for clustering key column " + (relation.keyColumn.getPosition() - 1));
            }
            prev = relation;
        }
    }

    private Triplet<Object, KeyColumn, Object> invoke(CallFrame frame, boolean partitionKey) {
        KeyColumn keyColumn = null;
        PropertyDescriptor desc = Reflection.propertyDescriptor((Method)frame.getMethod());
        List<KeyColumn> list = partitionKey ? this.table.getPartitionKeys() : this.table.getClusteringKeys();
        for (KeyColumn kc : list) {
            String name = kc.getPropertyDescriptor() != null ? kc.getPropertyDescriptor().getName() : kc.getField().getName();
            if (!name.equals(desc.getName())) continue;
            keyColumn = kc;
            break;
        }
        Object arg = null;
        Object ret = null;
        if (frame.getMethod().getReturnType() != Void.TYPE) {
            ret = Primitives.defaultValue(frame.getMethod().getReturnType());
        } else if (frame.getArguments().length > 0) {
            arg = frame.getArguments()[0];
        }
        return new Triplet(ret, (Object)keyColumn, arg);
    }

    protected class OrderByHandler
    implements InterceptorHandler {
        List<KeyColumnValue> keyColumnValues = new ArrayList<KeyColumnValue>();

        protected OrderByHandler() {
        }

        public Object invoke(CallFrame frame) {
            Triplet triplet = BaseQuery.this.invoke(frame, false);
            this.keyColumnValues.add(new KeyColumnValue((KeyColumn)triplet.y(), triplet.z()));
            return triplet.x();
        }
    }

    protected class RelationHandler
    implements InterceptorHandler {
        KeyColumn keyColumn;
        boolean partitionKey;

        RelationHandler(boolean partitionKey) {
            this.partitionKey = partitionKey;
        }

        public Object invoke(CallFrame frame) {
            Triplet pair = BaseQuery.this.invoke(frame, this.partitionKey);
            this.keyColumn = (KeyColumn)pair.y();
            return pair.x();
        }
    }

    protected class KeyColumnValue {
        KeyColumn keyColumn;
        Object value;

        public KeyColumnValue(KeyColumn keyColumn, Object value) {
            this.keyColumn = keyColumn;
            this.value = value;
        }
    }

    protected class Relation {
        Comparison comparison;
        KeyColumn keyColumn;
        Object value;
        Inspector.ColumnAccessor accessor;

        public Relation(KeyColumn keyColumn, Comparison comparison, Object value) {
            this.keyColumn = keyColumn;
            this.comparison = comparison;
            this.value = value;
            this.accessor = BaseQuery.this.inspector.getColumn(keyColumn.getName());
        }

        public boolean isRelated(T t, T t2) {
            Object v1 = this.accessor.get(t);
            Object v2 = this.accessor.get(t2);
            return Objects.equals(v1, v2);
        }
    }

    protected static enum Comparison {
        EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL;

    }
}

