/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.e6tech.elements.cassandra.Consistency;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;

public class Transformer<T, E> {
    private Resources resources;
    private Map<PrimaryKey, T> map = new HashMap<PrimaryKey, T>();
    private Class<T> tableClass;
    private List<Pair<PrimaryKey, E>> entries = Collections.synchronizedList(new LinkedList());
    private boolean hasCheckpoint;
    private Inspector tableInspector;
    private Consistency readConsistency = null;
    private Consistency writeConsistency = null;
    private long timeout = 0L;

    public Transformer(Resources resources, Class<T> cls) {
        this.resources = resources;
        this.tableClass = cls;
        this.tableInspector = this.getInspector(this.tableClass);
        this.hasCheckpoint = this.tableInspector.getCheckpointColumn(0) != null;
    }

    public Transformer<T, E> transform(Stream<E> stream, BiConsumer<Transformer<T, E>, E> consumer) {
        stream.forEach(e -> consumer.accept(this, e));
        this.load();
        return this;
    }

    public Transformer<T, E> transform(E[] array, BiConsumer<Transformer<T, E>, E> consumer) {
        for (E e : array) {
            consumer.accept(this, e);
        }
        this.load();
        return this;
    }

    public Transformer<T, E> transform(Collection<E> collection, BiConsumer<Transformer<T, E>, E> consumer) {
        for (E e : collection) {
            consumer.accept(this, e);
        }
        this.load();
        return this;
    }

    public Consistency getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(Consistency readConsistency) {
        this.readConsistency = readConsistency;
    }

    public Consistency getWriteConsistency() {
        return this.writeConsistency;
    }

    public void setWriteConsistency(Consistency writeConsistency) {
        this.writeConsistency = writeConsistency;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Transformer<T, E> timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public Transformer<T, E> addPrimaryKey(PrimaryKey key, E e) {
        if (key == null) {
            return this;
        }
        int keyColumns = this.tableInspector.getPartitionKeySize() + this.tableInspector.getClusteringKeySize();
        if (keyColumns != key.getKeys().length) {
            throw new IllegalArgumentException("Mismatch key columns.  The primary key for " + this.tableClass + " consists of " + keyColumns + " column(s): the provided primary key has " + key.getKeys().length + " componenets.");
        }
        this.entries.add(new Pair((Object)key, e));
        return this;
    }

    private Transformer<T, E> load() {
        Sibyl s = (Sibyl)this.resources.getInstance(Sibyl.class);
        this.map = new HashMap<PrimaryKey, T>(Math.max((int)((float)this.entries.size() / 0.75f) + 1, 16));
        HashSet<PrimaryKey> keys = new HashSet<PrimaryKey>(Math.max((int)((float)this.entries.size() / 0.75f) + 1, 16));
        for (Pair<PrimaryKey, E> e : this.entries()) {
            keys.add((PrimaryKey)e.key());
        }
        ReadOptions readOptions = new ReadOptions();
        readOptions.consistency = this.readConsistency;
        s.get(keys, this.tableClass, readOptions).timeout(this.timeout).inExecutionOrder(this.map::put);
        return this;
    }

    private Collection<Pair<PrimaryKey, E>> entries() {
        return this.entries;
    }

    private Inspector getInspector(Class cls) {
        return ((SessionProvider)this.resources.getInstance(SessionProvider.class)).getInspector(cls);
    }

    private T computeIfAbsent(PrimaryKey key) {
        return (T)this.map.computeIfAbsent(key, k -> {
            try {
                T t = this.tableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.tableInspector.setPrimaryKey(key, t);
                return t;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
    }

    public Transformer<T, E> forEachCreateIfNotExist(BiConsumer<E, T> consumer) {
        this.forEachNewOrExisting(consumer, consumer);
        return this;
    }

    public Transformer<T, E> forEachNewOrExisting(BiConsumer<E, T> newItems, BiConsumer<E, T> existing) {
        T t;
        Inspector extractedInspector = null;
        for (Pair<PrimaryKey, E> e : this.entries()) {
            Comparable extractedPartitionKey;
            boolean existingItem = this.map.get(e.key()) != null;
            t = this.computeIfAbsent((PrimaryKey)e.key());
            Object extracted = e.value();
            if (extractedInspector == null) {
                extractedInspector = this.getInspector(extracted.getClass());
            }
            boolean duplicate = false;
            if (this.hasCheckpoint && (extractedPartitionKey = (Comparable)extractedInspector.getPartitionKey(extracted, 0)) != null) {
                Comparable checkPoint = this.tableInspector.getCheckpoint(t, 0);
                boolean bl = duplicate = checkPoint != null && extractedPartitionKey.compareTo(checkPoint) <= 0;
            }
            if (duplicate) continue;
            if (existingItem) {
                existing.accept(extracted, t);
                continue;
            }
            newItems.accept(extracted, t);
        }
        for (Pair<PrimaryKey, E> e : this.entries()) {
            Object extracted = e.value();
            if (!this.hasCheckpoint) continue;
            t = this.computeIfAbsent((PrimaryKey)e.key());
            Comparable extractedPartitionKey = (Comparable)extractedInspector.getPartitionKey(extracted, 0);
            if (extractedPartitionKey == null) continue;
            this.tableInspector.setCheckpoint(t, 0, extractedPartitionKey);
        }
        return this;
    }

    public Transformer<T, E> save() {
        return this.save(null);
    }

    public Transformer<T, E> save(WriteOptions userOptions) {
        WriteOptions options = WriteOptions.from(userOptions);
        if (options.consistency == null && this.writeConsistency != null) {
            options.consistency = this.writeConsistency;
        }
        options.timeout = this.timeout;
        Sibyl s = (Sibyl)this.resources.getInstance(Sibyl.class);
        s.save(this.values(), this.tableClass, options);
        return this;
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public Set<PrimaryKey> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }
}

