/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.DaoBase;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.driver.cql.Row;
import net.e6tech.elements.cassandra.driver.v4.Helper;
import net.e6tech.elements.cassandra.driver.v4.Mapper;
import net.e6tech.elements.cassandra.driver.v4.RowV4;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.common.logging.Logger;

public class MapperImpl<T>
extends DaoBase
implements Mapper<T> {
    private static final Logger LOG = Logger.getLogger();
    private final Helper<T> helper;
    private final PreparedStatement findByIdStatement;
    private final PreparedStatement saveStatement;
    private final PreparedStatement deleteStatement;
    private Inspector inspector;
    private Map<WriteOptions, PreparedStatement> saveStatements = new ConcurrentHashMap<WriteOptions, PreparedStatement>();

    private MapperImpl(MapperContext context, Helper helper, Inspector inspector, PreparedStatement findByIdStatement, PreparedStatement saveStatement, PreparedStatement deleteStatement) {
        super(context);
        this.helper = helper;
        this.inspector = inspector;
        this.findByIdStatement = findByIdStatement;
        this.saveStatement = saveStatement;
        this.deleteStatement = deleteStatement;
    }

    @Override
    public T one(ResultSet resultSet) {
        com.datastax.oss.driver.api.core.cql.Row row = (com.datastax.oss.driver.api.core.cql.Row)resultSet.one();
        return row == null ? null : (T)this.helper.get((GettableByName)row);
    }

    @Override
    public T one(AsyncResultSet resultSet) {
        com.datastax.oss.driver.api.core.cql.Row row = (com.datastax.oss.driver.api.core.cql.Row)resultSet.one();
        return row == null ? null : (T)this.helper.get((GettableByName)row);
    }

    @Override
    public T map(Row row) {
        if (row == null) {
            return null;
        }
        return this.helper.get((GettableByName)((RowV4)row).unwrap());
    }

    @Override
    public PagingIterable<T> all(ResultSet resultSet) {
        return resultSet.map(this.helper::get);
    }

    @Override
    public MappedAsyncPagingIterable<T> all(AsyncResultSet resultSet) {
        return resultSet.map(this.helper::get);
    }

    private BoundStatement getBoundStatement(ReadOptions options, Object ... keys) {
        BoundStatementBuilder boundStatementBuilder = this.findByIdStatement.boundStatementBuilder(new Object[0]);
        int i = 0;
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set(accessor.getColumnName(), keys[i], accessor.getType());
            ++i;
        }
        BoundStatement boundStatement = boundStatementBuilder.build();
        if (options != null && options.consistency != null) {
            boundStatement = (BoundStatement)boundStatement.setConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)options.consistency.name()));
        }
        return boundStatement;
    }

    @Override
    public T get(ReadOptions readOptions, Object ... keys) {
        return (T)this.executeAndMapToSingleEntity((Statement)this.getBoundStatement(readOptions, keys), (EntityHelper)this.helper);
    }

    @Override
    public CompletionStage<T> getAsync(ReadOptions readOptions, Object ... keys) {
        try {
            return this.executeAsyncAndMapToSingleEntity((Statement)this.getBoundStatement(readOptions, keys), (EntityHelper)this.helper);
        }
        catch (Exception t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    private BoundStatement saveBoundStatement(WriteOptions options, T entity) {
        BoundStatement boundStatement;
        PreparedStatement save = options == null ? this.saveStatement : this.saveStatements.computeIfAbsent(options, wo -> {
            RegularInsert insert = this.helper.insert();
            if (options.ifNotExists != null && options.ifNotExists.booleanValue()) {
                insert = insert.ifNotExists();
            }
            if (options.ttl != null) {
                insert = insert.usingTtl(options.ttl.intValue());
            }
            SimpleStatement simple = insert.build();
            return this.context.getSession().prepare(simple);
        });
        BoundStatementBuilder boundStatementBuilder = save.boundStatementBuilder(new Object[0]);
        if (options != null) {
            if (options.saveNullFields != null) {
                if (options.saveNullFields.booleanValue()) {
                    this.helper.set(entity, boundStatementBuilder, NullSavingStrategy.SET_TO_NULL);
                } else {
                    this.helper.set(entity, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
                }
            } else {
                this.helper.set(entity, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
            }
            boundStatement = boundStatementBuilder.build();
            if (options.consistency != null) {
                boundStatement = (BoundStatement)boundStatement.setConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)options.consistency.name()));
            }
        } else {
            this.helper.set(entity, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
            boundStatement = boundStatementBuilder.build();
        }
        return boundStatement;
    }

    @Override
    public void save(WriteOptions options, T entity) {
        this.execute((Statement)this.saveBoundStatement(options, entity));
    }

    @Override
    public CompletionStage<Void> saveAsync(WriteOptions options, T entity) {
        try {
            return this.executeAsyncAndMapToVoid((Statement)this.saveBoundStatement(options, entity));
        }
        catch (Exception t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public void delete(T entity) {
        BoundStatementBuilder boundStatementBuilder = this.deleteStatement.boundStatementBuilder(new Object[0]);
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            Object key = accessor.get(entity);
            boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set(accessor.getColumnName(), key, accessor.getType());
        }
        BoundStatement boundStatement = boundStatementBuilder.build();
        this.execute((Statement)boundStatement);
    }

    public static <T> CompletableFuture<MapperImpl<T>> initAsync(MapperContext context, Class<T> cls, Inspector inspector) {
        LOG.debug("[{}] Initializing new instance for keyspace = {} and table = {}", new Object[]{context.getSession().getName(), context.getKeyspaceId(), context.getTableId()});
        try {
            Helper helper = new Helper(context, cls, inspector);
            ArrayList<CompletionStage> prepareStages = new ArrayList<CompletionStage>();
            SimpleStatement getStatement_simple = helper.selectByPrimaryKey().build();
            LOG.debug("[{}] Preparing query `{}` for method get()", (Object)context.getSession().getName(), (Object)getStatement_simple.getQuery());
            CompletionStage getStatement = MapperImpl.prepare((SimpleStatement)getStatement_simple, (MapperContext)context);
            prepareStages.add(getStatement);
            SimpleStatement saveStatement_simple = helper.insert().build();
            LOG.debug("[{}] Preparing query `{}` for method save()", (Object)context.getSession().getName(), (Object)saveStatement_simple.getQuery());
            CompletionStage saveStatement = MapperImpl.prepare((SimpleStatement)saveStatement_simple, (MapperContext)context);
            prepareStages.add(saveStatement);
            SimpleStatement deleteStatement_simple = helper.deleteByPrimaryKey().build();
            LOG.debug("[{}] Preparing query `{}` for method delete()", (Object)context.getSession().getName(), (Object)deleteStatement_simple.getQuery());
            CompletionStage deleteStatement = MapperImpl.prepare((SimpleStatement)deleteStatement_simple, (MapperContext)context);
            prepareStages.add(deleteStatement);
            return CompletableFutures.allSuccessful(prepareStages).thenApply(v -> new MapperImpl(context, helper, inspector, (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)getStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)saveStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)deleteStatement))).toCompletableFuture();
        }
        catch (Exception t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static <T> Mapper<T> init(MapperContext context, Class<T> cls, Inspector inspector) {
        BlockingOperation.checkNotDriverThread();
        try {
            return (Mapper)CompletableFutures.getUninterruptibly(MapperImpl.initAsync(context, cls, inspector));
        }
        catch (Exception ex) {
            LOG.error("Cannot compile statements for class {}", cls);
            throw ex;
        }
    }
}

