/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.common.util.SystemException;

public class AsyncFutures<T, D> {
    protected Async<T, D> async;
    protected List<Future<T>> futures;
    private long timeout = 0L;

    AsyncFutures(Async async, List<Future<T>> futures) {
        this.async = async;
        this.futures = futures;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public AsyncFutures<T, D> timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    protected void futuresAccept(List<Future<T>> list, Consumer consumer) {
        for (Future<T> future : list) {
            try {
                T value;
                T t = value = this.timeout > 0L ? future.get(this.timeout, TimeUnit.MILLISECONDS) : future.get();
                if (consumer == null || value == null) continue;
                consumer.accept(value);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    public Async<T, D> inExecutionOrder() {
        this.futuresAccept(this.futures, null);
        return this.async;
    }

    public Async<T, D> inExecutionOrder(Consumer<T> consumer) {
        this.futuresAccept(this.futures, consumer);
        return this.async;
    }

    public Async<T, D> inExecutionOrder(BiConsumer<D, T> consumer) {
        Map futuresData = this.async.futuresData;
        for (Future<T> future : this.futures) {
            try {
                T value;
                T t = value = this.timeout > 0L ? future.get(this.timeout, TimeUnit.MILLISECONDS) : future.get();
                if (consumer == null || value == null) continue;
                consumer.accept(futuresData.get(future), value);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        return this.async;
    }
}

