/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.List;
import net.e6tech.elements.cassandra.etl.ETLContext;
import net.e6tech.elements.cassandra.etl.Strategy;

public interface BatchStrategy<S, C extends ETLContext>
extends Strategy<C> {
    public List<S> extract(C var1);

    public int load(C var1, List<S> var2);

    @Override
    default public int run(C context) {
        int importedCount = 0;
        List<S> batchResults = null;
        logger.info("Loading Class {}", this.getClass());
        while (!(batchResults = this.extract(context)).isEmpty()) {
            int processedCount = this.load(context, batchResults);
            logger.info("Processed {} instance of {}", (Object)processedCount, this.getClass());
            importedCount += processedCount;
        }
        logger.info("Done loading {} instance of {}", (Object)importedCount, this.getClass());
        return importedCount;
    }
}

