/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.etl.ETLSettings;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;
import net.e6tech.elements.common.util.SystemException;

public class ETLContext {
    public static final long DAY = 86400000L;
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final long SECOND = 1000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long TIME_LAG = 300000L;
    public static final int ASYNC_MAX_NUM_OF_CHUNKS = 100;
    public static final int BATCH_SIZE = 2000;
    private Provision provision;
    private ETLSettings settings = new ETLSettings();
    private int importedCount;
    private String extractorName;
    private String initialUpdate;
    private Class sourceClass;
    private TimeUnit timeUnit;
    private boolean initialized = false;
    private Class<LastUpdate> lastUpdateClass;
    private LastUpdate lastUpdate;
    private String useLastUpdate;

    public ETLContext() {
        this.settings.batchSize(2000).timeLag(300000L).maxPast(63072000000L).asyncTimeUnitStepSize(null).asyncMaxNumOfChunks(100).asyncUseFutures(false).retries(0).retrySleep(100L).extractAll(true).startTime(System.currentTimeMillis());
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Generator getGenerator() {
        return (Generator)this.getProvision().getInstance(Generator.class);
    }

    public UnitOfWork open() {
        return this.getProvision().open();
    }

    public int getBatchSize() {
        return this.settings.getBatchSize();
    }

    public void setBatchSize(int batchSize) {
        this.settings.setBatchSize(batchSize);
    }

    public Integer getAsyncTimeUnitStepSize() {
        return this.settings.getAsyncTimeUnitStepSize();
    }

    public void setAsyncTimeUnitStepSize(Integer asyncTimeUnitStepSize) {
        this.settings.setAsyncTimeUnitStepSize(asyncTimeUnitStepSize);
    }

    public Integer getAsyncMaxNumOfChunks() {
        return this.settings.getAsyncMaxNumOfChunks();
    }

    public void setAsyncMaxNumOfChunks(Integer asyncMaxNumOfChunks) {
        this.settings.setAsyncMaxNumOfChunks(asyncMaxNumOfChunks);
    }

    public boolean isAsyncUseFutures() {
        return this.settings.isAsyncUseFutures();
    }

    public void setAsyncUseFutures(boolean asyncUseFutures) {
        this.settings.setAsyncUseFutures(asyncUseFutures);
    }

    public long getTimeLag() {
        return this.settings.getTimeLag();
    }

    public void setTimeLag(long timeLag) {
        this.settings.setTimeLag(timeLag);
    }

    public long getMaxPast() {
        return this.settings.getMaxPast();
    }

    public void setMaxPast(long maxPast) {
        this.settings.setMaxPast(maxPast);
    }

    public int getRetries() {
        return this.settings.getRetries();
    }

    public void setRetries(int retries) {
        this.settings.setRetries(retries);
    }

    public long getRetrySleep() {
        return this.settings.getRetrySleep();
    }

    public void setRetrySleep(long sleep) {
        this.settings.setRetrySleep(sleep);
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public void setImportedCount(int importedCount) {
        this.importedCount = importedCount;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public long getStartTime() {
        return this.settings.getStartTime();
    }

    public void setStartTime(long startTime) {
        this.settings.setStartTime(startTime);
    }

    public boolean isExtractAll() {
        return this.settings.getExtractAll();
    }

    public void setExtractAll(boolean extractAll) {
        this.settings.setExtractAll(extractAll);
    }

    public String getInitialUpdate() {
        return this.initialUpdate;
    }

    public void setInitialUpdate(String initialUpdate) {
        this.initialUpdate = initialUpdate;
    }

    public String getExtractorName() {
        return this.extractorName;
    }

    public void setExtractorName(String extractorName) {
        this.extractorName = extractorName;
    }

    public String extractor() {
        return this.getExtractorName() != null ? this.getExtractorName() : this.getSourceClass().getName();
    }

    public Class<LastUpdate> getLastUpdateClass() {
        return this.lastUpdateClass;
    }

    public void setLastUpdateClass(Class<LastUpdate> lastUpdateClass) {
        this.lastUpdateClass = lastUpdateClass;
    }

    public Class getPartitionKeyType() {
        this.initialize();
        return this.getInspector(this.getSourceClass()).getPartitionKeyClass(0);
    }

    public void reset() {
    }

    public TimeUnit getTimeUnit() {
        String partitionKeyColumn;
        this.initialize();
        if (this.timeUnit == null && (partitionKeyColumn = this.getInspector(this.getSourceClass()).getPartitionKeyColumn(0)) != null) {
            this.timeUnit = partitionKeyColumn.endsWith("_day") ? TimeUnit.DAYS : (partitionKeyColumn.endsWith("_hour") ? TimeUnit.HOURS : (partitionKeyColumn.endsWith("_minute") ? TimeUnit.MINUTES : (partitionKeyColumn.endsWith("_second") ? TimeUnit.SECONDS : (partitionKeyColumn.endsWith("_milli") ? TimeUnit.MILLISECONDS : (partitionKeyColumn.endsWith("_time") ? TimeUnit.MILLISECONDS : (partitionKeyColumn.endsWith("_epoch") ? TimeUnit.MILLISECONDS : null))))));
        }
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String tableName() {
        return this.getInspector(this.getSourceClass()).tableName();
    }

    public void saveLastUpdate(LastUpdate lastUpdate) {
        if (this.useLastUpdate != null) {
            return;
        }
        this.open().accept(Sibyl.class, sibyl -> {
            if (this.lastUpdateClass == null) {
                this.lastUpdateClass = (Class)this.getProvision().open().apply(Resources.class, resources -> ((SessionProvider)resources.getInstance(SessionProvider.class)).getLastUpdateClass());
            }
            sibyl.save(this.lastUpdateClass, lastUpdate);
            this.lastUpdate = lastUpdate;
        });
    }

    public LastUpdate lookupLastUpdate() {
        if (this.lastUpdate != null) {
            return this.lastUpdate;
        }
        if (this.lastUpdateClass == null) {
            this.lastUpdateClass = ((SessionProvider)this.getProvision().getInstance(SessionProvider.class)).getLastUpdateClass();
        }
        this.lastUpdate = (LastUpdate)this.open().apply(Sibyl.class, sibyl -> sibyl.get(this.lastUpdateClass, new PrimaryKey(this.extractor())));
        return this.lastUpdate;
    }

    public LastUpdate getLastUpdate() {
        String name = this.extractor();
        this.lookupLastUpdate();
        if (this.lastUpdate == null) {
            try {
                this.lastUpdate = ((SessionProvider)this.getProvision().getInstance(SessionProvider.class)).getLastUpdateClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            this.lastUpdate.setExtractor(name);
            if (this.initialUpdate != null) {
                this.lastUpdate.setLastUpdate(this.getInitialUpdate());
            } else if (this.settings.getExtractAll().booleanValue()) {
                if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
                    this.lastUpdate.setLastUpdate(new UUID(Long.MIN_VALUE, Long.MIN_VALUE).toString());
                } else {
                    this.lastUpdate.setLastUpdate("0");
                    if (this.settings.getStartTime() != null) {
                        this.lastUpdate.setLastUpdate("" + this.cutoffOrUpdate(false, this.settings.getStartTime(), 1L));
                    }
                }
            } else {
                this.lastUpdate.setLastUpdate("" + this.cutoffOrUpdate(false, this.settings.getStartTime(), 1L));
            }
            this.lastUpdate.setDataType(this.getGenerator().getDataType(this.getPartitionKeyType()));
            if (this.getTimeUnit() != null) {
                this.lastUpdate.setUnit(this.getTimeUnit().toString());
            } else {
                this.lastUpdate.setUnit("1");
            }
            if (this.useLastUpdate != null) {
                this.lastUpdate.setLastUpdate(this.useLastUpdate);
            }
        }
        return this.lastUpdate;
    }

    protected ETLContext lastUpdate(LastUpdate lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public Object getLastUpdateValue() {
        LastUpdate l = this.getLastUpdate();
        return this.getGenerator().getDataValue(l.getDataType(), l.getLastUpdate());
    }

    public Comparable getCutoff() {
        return this.cutoffOrUpdate(true, this.settings.getStartTime(), 0L);
    }

    public Comparable getCutoff(long startTime, long additionalLag) {
        return this.cutoffOrUpdate(true, startTime, additionalLag);
    }

    private Comparable cutoffOrUpdate(boolean cutoff, long startTime, long additionalLag) {
        long timeLag = this.settings.getTimeLag() + additionalLag;
        if (TimeUnit.DAYS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf((startTime - timeLag) / 86400000L);
        }
        if (TimeUnit.HOURS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf((startTime - timeLag) / 3600000L);
        }
        if (TimeUnit.MINUTES.equals((Object)this.getTimeUnit())) {
            return Long.valueOf((startTime - timeLag) / 60000L);
        }
        if (TimeUnit.SECONDS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf((startTime - timeLag) / 1000L);
        }
        if (TimeUnit.MILLISECONDS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(startTime - timeLag);
        }
        if (cutoff) {
            if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
                return new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
            }
            return Long.valueOf(Long.MAX_VALUE);
        }
        if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
            return new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
        }
        return Long.valueOf(0L);
    }

    public Inspector getInspector() {
        return this.getInspector(this.getSourceClass());
    }

    public Inspector getInspector(Class cls) {
        return ((SessionProvider)this.provision.getInstance(SessionProvider.class)).getInspector(cls);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Inspector inspector = this.getInspector(this.getSourceClass());
        if (this.timeUnit == null) {
            this.timeUnit = inspector.getTimeUnit();
        }
    }

    public void copy(ETLContext context) {
        this.setStartTime(context.getStartTime());
        this.setProvision(context.getProvision());
        this.setBatchSize(context.getBatchSize());
        this.setExtractAll(context.isExtractAll());
        this.setTimeLag(context.getTimeLag());
        this.setMaxPast(context.getMaxPast());
        this.setAsyncTimeUnitStepSize(context.getAsyncTimeUnitStepSize());
        this.setAsyncMaxNumOfChunks(context.getAsyncMaxNumOfChunks());
        this.setAsyncUseFutures(context.isAsyncUseFutures());
        this.setRetries(context.getRetries());
        this.setRetrySleep(context.getRetrySleep());
    }

    public void copy(ETLSettings s) {
        if (s == null) {
            return;
        }
        if (s.getStartTime() != null) {
            this.setStartTime(s.getStartTime());
        }
        if (s.getBatchSize() != null) {
            this.setBatchSize(s.getBatchSize());
        }
        if (s.getExtractAll() != null) {
            this.setExtractAll(s.getExtractAll());
        }
        if (s.getTimeLag() != null) {
            this.setTimeLag(s.getTimeLag());
        }
        if (s.getMaxPast() != null) {
            this.setMaxPast(s.getMaxPast());
        }
        if (s.getAsyncTimeUnitStepSize() != null) {
            this.setAsyncTimeUnitStepSize(s.getAsyncTimeUnitStepSize());
        }
        if (s.getAsyncMaxNumOfChunks() != null) {
            this.setAsyncMaxNumOfChunks(s.getAsyncMaxNumOfChunks());
        }
        if (s.isAsyncUseFutures() != null) {
            this.setAsyncUseFutures(s.isAsyncUseFutures());
        }
        if (s.getRetries() != null) {
            this.setRetries(s.getRetries());
        }
        if (s.getRetrySleep() != null) {
            this.setRetrySleep(s.getRetrySleep());
        }
    }
}

