/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.mapper.MapperBuilder;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.internal.mapper.DefaultMapperContext;
import java.util.concurrent.ConcurrentMap;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.driver.v4.Mapper;
import net.e6tech.elements.cassandra.driver.v4.MapperImpl;
import net.e6tech.elements.cassandra.etl.Inspector;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class MappingManager {
    protected final SessionProvider sessionProvider;
    protected final CqlSession session;
    private String keyspace;
    private ConcurrentMap<Class, MyMapperBuilder> builders = new ConcurrentHashMap();

    public MappingManager(SessionProvider sessionProvider, CqlSession session, String keyspace) {
        this.sessionProvider = sessionProvider;
        this.session = session;
        this.keyspace = keyspace;
        if (keyspace == null) {
            this.keyspace = session.getKeyspace().map(CqlIdentifier::asInternal).orElse(null);
        }
    }

    public <T> Mapper<T> getMapper(Class<T> cls) {
        MyMapperBuilder builder = this.builders.computeIfAbsent(cls, key -> {
            MyMapperBuilder b = new MyMapperBuilder(this.session);
            return b.build(cls, this.keyspace);
        });
        return builder.getMapper();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    private class MyMapperBuilder<T>
    extends MapperBuilder<T> {
        private LazyReference<Mapper<T>> cache;

        protected MyMapperBuilder(CqlSession session) {
            super(session);
        }

        public T build() {
            return null;
        }

        public MyMapperBuilder build(Class cls, String keyspace) {
            Inspector inspector = MappingManager.this.sessionProvider.getInspector(cls);
            CqlIdentifier tableId = CqlIdentifier.fromInternal((String)inspector.tableName());
            CqlIdentifier keyspaceId = CqlIdentifier.fromInternal((String)keyspace);
            DefaultMapperContext context = new DefaultMapperContext(this.session, this.defaultKeyspaceId, this.defaultExecutionProfileName, this.defaultExecutionProfile, this.customState).withDaoParameters(keyspaceId, tableId, null, null);
            this.cache = new LazyReference(() -> MapperImpl.init((MapperContext)context, cls, inspector));
            return this;
        }

        public Mapper<T> getMapper() {
            return (Mapper)this.cache.get();
        }
    }
}

