/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.driver.cql.AsyncResultSet;
import net.e6tech.elements.cassandra.driver.metadata.TableMetadata;
import net.e6tech.elements.cassandra.etl.ETLContext;
import net.e6tech.elements.cassandra.etl.Strategy;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.IndexGenerator;
import net.e6tech.elements.cassandra.generator.TableGenerator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.PackageScanner;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.common.util.SystemException;

public class Schema {
    private static Cache<String, List<String>> scriptCache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(1000L).build();
    private static Logger logger = Logger.getLogger();
    private Provision provision;
    private List<Map<String, String>> codecs = new ArrayList<Map<String, String>>();
    private boolean dropColumn = false;
    private int threadSize = 1;
    private long validationWait = 1000L;
    private int tableCreationAsyncSize = 0;

    public int getThreadSize() {
        return this.threadSize;
    }

    public void setThreadSize(int threadSize) {
        this.threadSize = threadSize;
    }

    public Schema threadSize(int threadSize) {
        this.setThreadSize(threadSize);
        return this;
    }

    public long getValidationWait() {
        return this.validationWait;
    }

    public void setValidationWait(long validationWait) {
        this.validationWait = validationWait;
    }

    public int getTableCreationAsyncSize() {
        return this.tableCreationAsyncSize;
    }

    public void setTableCreationAsyncSize(int tableCreationAsyncSize) {
        this.tableCreationAsyncSize = tableCreationAsyncSize;
    }

    public Schema validationWait(long wait) {
        this.setValidationWait(wait);
        return this;
    }

    public List<Map<String, String>> getCodecs() {
        return this.codecs;
    }

    public void setCodecs(List<Map<String, String>> codecs) {
        this.codecs = codecs;
    }

    public boolean isDropColumn() {
        return this.dropColumn;
    }

    public void setDropColumn(boolean dropColumn) {
        this.dropColumn = dropColumn;
    }

    public SessionProvider getProvider(Resources resources) {
        return (SessionProvider)resources.getInstance(SessionProvider.class);
    }

    private <A extends Annotation> Class[] scanClasses(Class<A> annotationClass, String ... packageNames) {
        if (packageNames == null || packageNames.length == 0) {
            return new Class[0];
        }
        PackageScanner packageScanner = new PackageScanner();
        ArrayList<Class> list = new ArrayList<Class>();
        for (String packageName : packageNames) {
            Class[] classes;
            for (Class cls : classes = packageScanner.getTopLevelClassesRecursive(this.provision.getPluginClassLoader(), packageName)) {
                if (cls.getAnnotation(annotationClass) == null) continue;
                list.add(cls);
            }
        }
        return list.toArray(new Class[0]);
    }

    public void createTables(String keyspace, String ... packageNames) {
        Generator generator = ((SessionProvider)this.provision.getInstance(SessionProvider.class)).getGenerator();
        Class<? extends Annotation> annotation = generator.tableAnnotation();
        Class[] classes = this.scanClasses(annotation, packageNames);
        this.createTables(keyspace, classes);
    }

    public void createTables(String keyspace, Class ... classes) {
        if (classes == null) {
            return;
        }
        this.provision.open().accept(Resources.class, resources -> {
            List<Object> tableGenerators = new LinkedList();
            Session session = (Session)resources.getInstance(Session.class);
            SessionProvider provider = this.getProvider((Resources)resources);
            if (this.tableCreationAsyncSize <= 1) {
                for (Class clazz : classes) {
                    TableGenerator tableGenerator = provider.getGenerator().getTable(keyspace, clazz);
                    String cql = tableGenerator.generate();
                    if (logger.isInfoEnabled()) {
                        logger.info("Creating table synchronously, {}", (Object)tableGenerator.fullyQualifiedTableName());
                    }
                    session.execute(keyspace, cql);
                    tableGenerators.add(tableGenerator);
                }
            } else {
                tableGenerators = this.asyncTableGen((Resources)resources, keyspace, classes);
            }
            for (TableGenerator tableGenerator : tableGenerators) {
                try {
                    tableGenerator.diff(session, keyspace, provider.getTableMetadata(keyspace, tableGenerator.getTableName()), this.isDropColumn());
                }
                catch (Throwable th) {
                    throw new SystemException("Cannot diff table " + tableGenerator.getTableName(), th);
                }
            }
            for (Class clazz : classes) {
                IndexGenerator indexGenerator = provider.getGenerator().createIndexes(keyspace, clazz);
                List<String> statements = indexGenerator.generate();
                for (String cql : statements) {
                    try {
                        logger.info("Generating indexes asynchronously for class {}", (Object)indexGenerator.fullyQualifiedTableName());
                        session.execute(keyspace, cql);
                        Future<AsyncResultSet> future = session.executeAsync(keyspace, cql);
                    }
                    catch (Exception ex) {
                        logger.info("Syntax error in creating index for {}", (Object)clazz);
                        logger.info(cql);
                        throw ex;
                    }
                }
            }
        });
        this.validateTables(keyspace, classes);
    }

    protected List<TableGenerator> asyncTableGen(Resources resources, String keyspace, Class ... classes) {
        LinkedList<TableGenerator> tableGenerators = new LinkedList<TableGenerator>();
        int index = 0;
        ArrayList<Class> chunk = new ArrayList<Class>();
        for (int i = index; i < classes.length && chunk.size() < this.tableCreationAsyncSize; ++i) {
            chunk.add(classes[i]);
            index = i + 1;
        }
        ArrayList<AsyncTableGenerator> tableCreation = new ArrayList<AsyncTableGenerator>();
        while (!chunk.isEmpty()) {
            for (Class cls : chunk) {
                if (this.getTableName(cls) == null) continue;
                AsyncTableGenerator asyncTableGenerator = new AsyncTableGenerator(resources, keyspace, cls);
                tableCreation.add(asyncTableGenerator);
                tableGenerators.add(asyncTableGenerator.generator());
            }
            for (AsyncTableGenerator asyncTableGenerator : tableCreation) {
                try {
                    asyncTableGenerator.complete();
                }
                catch (Exception ex) {
                    throw new SystemException("Cannot create table for " + asyncTableGenerator.tableClass.getName(), (Throwable)ex);
                }
            }
            tableCreation.clear();
            chunk = new ArrayList();
            for (int i = index; i < classes.length && chunk.size() < this.tableCreationAsyncSize; ++i) {
                chunk.add(classes[i]);
                index = i + 1;
            }
        }
        return tableGenerators;
    }

    protected String getTableName(Class entityClass) {
        Generator generator = ((SessionProvider)this.provision.getInstance(SessionProvider.class)).getGenerator();
        for (Class tmp = entityClass; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (generator.tableAnnotation(tmp) == null) continue;
            return generator.tableName(tmp);
        }
        return null;
    }

    public void validateTables(String keyspace, Class ... classes) {
        AtomicBoolean validated = new AtomicBoolean(classes.length == 0);
        AtomicInteger index = new AtomicInteger(0);
        while (!validated.get()) {
            this.provision.open().accept(Resources.class, resources -> {
                SessionProvider provider = this.getProvider((Resources)resources);
                for (int i = index.get(); i < classes.length; ++i) {
                    Class cls = classes[i];
                    TableGenerator generator = provider.getGenerator().getTable(keyspace, cls);
                    TableMetadata metadata = provider.getTableMetadata(keyspace, generator.getTableName());
                    if (metadata == null) {
                        index.set(i);
                        break;
                    }
                    if (i != classes.length - 1) continue;
                    validated.set(true);
                }
            });
            if (validated.get()) continue;
            try {
                Thread.sleep(this.validationWait);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void runScripts(ScriptType type, Class ... classes) {
        this.provision.open().accept(Resources.class, resources -> {
            for (Class cls : classes) {
                List<String> statements = Schema.getScript(cls, type);
                for (String stmt : statements) {
                    ((Session)resources.getInstance(Session.class)).execute(stmt);
                }
            }
        });
    }

    public void runScripts(String keyspace, ScriptType type, Class ... classes) {
        this.provision.open().accept(Resources.class, resources -> {
            for (Class cls : classes) {
                List<String> statements = Schema.getScript(cls, type);
                for (String stmt : statements) {
                    ((Session)resources.getInstance(Session.class)).execute(keyspace, stmt);
                }
            }
        });
    }

    public static List<String> getScript(Class cls, ScriptType type) {
        String tmp = "";
        if (type != null) {
            tmp = "_" + type.name();
        }
        String postfix = tmp;
        try {
            return (List)scriptCache.get((Object)(cls.getName() + postfix), () -> {
                try (BufferedInputStream stream = new BufferedInputStream(cls.getResourceAsStream(cls.getSimpleName() + postfix + ".cql"));){
                    int size;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((size = stream.read(buffer)) != -1) {
                        output.write(buffer, 0, size);
                    }
                    String file = new String(output.toByteArray(), StandardCharsets.UTF_8);
                    String[] statments = file.split(";");
                    ArrayList<String> list = new ArrayList<String>();
                    for (String stmt : statments) {
                        if (StringUtil.isNullOrEmpty((String)stmt)) continue;
                        list.add(stmt);
                    }
                    List list2 = Collections.unmodifiableList(list);
                    return list2;
                }
            });
        }
        catch (ExecutionException e) {
            logger.error("Cannot retrieve script {}{}.cql ", (Object)cls.getSimpleName(), (Object)postfix);
            throw new SystemException((Throwable)e);
        }
    }

    public void extract(String packageName) {
        this.extract(packageName, false);
    }

    public void extractRecursive(String packageName) {
        this.extract(packageName, true);
    }

    public void extract(String packageName, boolean recursive) {
        this.extract(packageName, recursive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extract(String packageName, boolean recursive, Consumer<ETLContext> customizer) {
        Map<Class<Strategy>, ETLContext> map = this.scan(packageName, recursive, customizer);
        ExecutorService threadPool = null;
        try {
            int totalEntries = map.size();
            if (totalEntries == 0) {
                return;
            }
            int threadNeeded = this.threadSize;
            if (threadNeeded > map.size()) {
                threadNeeded = map.size();
            }
            threadPool = Executors.newFixedThreadPool(threadNeeded);
            LinkedList futures = new LinkedList();
            for (Map.Entry<Class<Strategy>, ETLContext> entry : map.entrySet()) {
                Future<?> future = threadPool.submit(() -> {
                    try {
                        Strategy strategy = (Strategy)((Class)entry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        strategy.run((ETLContext)entry.getValue());
                    }
                    catch (Exception e) {
                        logger.error("Cannot extract {}", entry.getKey());
                        throw new SystemException((Throwable)e);
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (!(e.getCause() instanceof RuntimeException)) throw new SystemException(e.getCause());
                    throw (RuntimeException)e.getCause();
                    return;
                }
            }
        }
        finally {
            if (threadPool != null) {
                threadPool.shutdown();
            }
        }
    }

    public Map<Class<Strategy>, ETLContext> scan(String packageName, boolean recursive, Consumer<ETLContext> customizer) {
        PackageScanner scanner = new PackageScanner();
        Class[] classes = recursive ? scanner.getTopLevelClassesRecursive(this.provision.getPluginClassLoader(), packageName) : scanner.getTopLevelClasses(this.provision.getPluginClassLoader(), packageName);
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) continue;
            list.clear();
            for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                this.analyze(clazz2, list);
            }
            if (list.isEmpty()) continue;
            map.put(clazz, list.get(0));
        }
        LinkedHashMap<Class<Strategy>, ETLContext> result = new LinkedHashMap<Class<Strategy>, ETLContext>();
        for (Map.Entry entry : map.entrySet()) {
            Object var11_15 = null;
            try {
                ETLContext eTLContext = (ETLContext)this.provision.newInstance((Class)entry.getValue());
                if (customizer != null) {
                    customizer.accept(eTLContext);
                }
                result.put((Class<Strategy>)entry.getKey(), eTLContext);
            }
            catch (Exception e) {
                logger.error("Cannot extract {}", entry.getKey());
                throw new SystemException((Throwable)e);
            }
        }
        return result;
    }

    private void analyze(Class cls, List<Class> list) {
        if (Strategy.class.isAssignableFrom(cls)) {
            block0: for (TypeVariable typeVar : cls.getTypeParameters()) {
                for (Type t : typeVar.getBounds()) {
                    if (!(t instanceof Class) || !ETLContext.class.isAssignableFrom((Class)t)) continue;
                    list.add((Class)t);
                    continue block0;
                }
            }
            Type sup = cls.getGenericSuperclass();
            if (sup instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)sup;
                for (Type arg : ptype.getActualTypeArguments()) {
                    if (!(arg instanceof Class) || !ETLContext.class.isAssignableFrom((Class)arg)) continue;
                    list.add((Class)arg);
                }
            }
            for (Type type : cls.getGenericInterfaces()) {
                ParameterizedType ptype;
                if (!(type instanceof ParameterizedType) || !Strategy.class.isAssignableFrom((Class)(ptype = (ParameterizedType)type).getRawType())) continue;
                for (Type arg : ptype.getActualTypeArguments()) {
                    if (!(arg instanceof Class) || !ETLContext.class.isAssignableFrom((Class)arg)) continue;
                    list.add((Class)arg);
                }
                this.analyze((Class)ptype.getRawType(), list);
            }
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    class AsyncTableGenerator {
        String keyspace;
        SessionProvider provider;
        Session session;
        TableGenerator tableGenerator;
        TableMetadata metadata;
        Class tableClass;
        Future<AsyncResultSet> future;

        AsyncTableGenerator(Resources resources, String keyspace, Class cls) {
            this.keyspace = keyspace;
            this.session = (Session)resources.getInstance(Session.class);
            this.provider = Schema.this.getProvider(resources);
            this.tableGenerator = this.provider.getGenerator().getTable(keyspace, cls);
            this.tableClass = cls;
            this.generate();
        }

        TableGenerator generator() {
            return this.tableGenerator;
        }

        void generate() {
            this.metadata = this.provider.getTableMetadata(this.keyspace, this.tableGenerator.getTableName());
            if (this.metadata == null) {
                String cql = this.tableGenerator.generate();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info("Creating table asynchronously, {}", (Object)this.tableGenerator.fullyQualifiedTableName());
                    }
                    this.future = this.session.executeAsync(this.keyspace, cql);
                }
                catch (Exception ex) {
                    logger.info("Syntax error in creating table for {}", (Object)this.tableClass);
                    logger.info(cql);
                    throw ex;
                }
            }
        }

        void complete() throws ExecutionException, InterruptedException {
            try {
                this.tryComplete();
                this.future = null;
            }
            catch (Exception ex) {
                this.tryComplete();
            }
        }

        void tryComplete() throws ExecutionException, InterruptedException {
            if (this.future == null) {
                this.generate();
            }
            if (this.metadata == null && this.future == null) {
                throw new ExecutionException("Cannot generate table " + this.tableClass.getName(), (Throwable)new SystemException("Cannot generate table " + this.tableClass.getName()));
            }
            if (this.future != null) {
                this.future.get();
            }
        }
    }

    public static enum ScriptType {
        create,
        extract;

    }
}

