/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.query.BaseQuery;

public class RangeQuery<T>
extends BaseQuery<T, RangeQuery<T>> {
    private boolean subQuery;

    public RangeQuery(Sibyl sibyl, Class<T> entityClass) {
        super(sibyl, entityClass);
    }

    public List<T> query() {
        this.validate();
        List list = this.select();
        return this.patchBoundary(list);
    }

    private List<T> patchBoundary(List<T> list) {
        if (!this.subQuery && !this.orderBy.isEmpty() && list.size() == this.limit && this.limit > 0) {
            T last = list.get(list.size() - 1);
            RangeQuery<T> sub = this.subQuery(last);
            return this.merge(list, sub.query(), last);
        }
        return list;
    }

    private RangeQuery<T> subQuery(T last) {
        RangeQuery<T> sub = new RangeQuery<T>(this.sibyl, this.entityClass);
        sub.subQuery = true;
        sub.partitionRelations = new ArrayList(this.partitionRelations);
        HashSet set = new HashSet();
        Consumer<BaseQuery.Relation> consumer = r -> {
            if (set.contains(r.keyColumn.getName())) {
                return;
            }
            BaseQuery.Relation subR = new BaseQuery.Relation(this, r.keyColumn, BaseQuery.Comparison.EQUAL, r.value);
            sub.clusteringRelations.add(subR);
            set.add(r.keyColumn.getName());
        };
        this.clusteringRelations.forEach(consumer);
        this.orderBy.forEach(consumer);
        for (BaseQuery.Relation r2 : sub.clusteringRelations) {
            r2.value = r2.accessor.get(last);
        }
        return sub;
    }

    private List<T> merge(List<T> list, List<T> list2, T last) {
        int trimLast = list.size();
        int i = list.size() - 1;
        while (i >= 0) {
            T t = list.get(i);
            boolean same = true;
            for (BaseQuery.Relation relation : this.orderBy) {
                if (relation.isRelated(last, t)) continue;
                same = false;
                break;
            }
            if (!same) break;
            trimLast = i--;
        }
        list = list.subList(0, trimLast);
        list.addAll(list2);
        return list;
    }
}

