/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.transmutator;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.driver.cql.ResultSet;
import net.e6tech.elements.cassandra.driver.cql.Row;
import net.e6tech.elements.cassandra.etl.ETLSettings;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.Partition;
import net.e6tech.elements.cassandra.etl.PartitionContext;
import net.e6tech.elements.cassandra.etl.PartitionStrategy;
import net.e6tech.elements.cassandra.etl.Strategy;
import net.e6tech.elements.cassandra.transmutator.Loader;
import net.e6tech.elements.cassandra.transmutator.PartitionLoader;
import net.e6tech.elements.common.util.MapBuilder;
import net.e6tech.elements.common.util.SystemException;

public abstract class Transmutator
implements Strategy<PartitionContext> {
    private LinkedList<Descriptor> descriptors = new LinkedList();
    private Customizer customizer = null;
    private Map<String, ETLSettings> settings = new HashMap<String, ETLSettings>();

    public Map<String, ETLSettings> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, ETLSettings> settings) {
        this.settings = settings;
    }

    public Customizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(Customizer customizer) {
        this.customizer = customizer;
    }

    protected void undo(PartitionContext context, Class tableClass) {
        context.open().accept(Sibyl.class, sibyl -> {
            Inspector inspector = context.getInspector(tableClass);
            String tableName = inspector.tableName();
            String partitionKey = inspector.getPartitionKeyColumn(0);
            String checkpointColumn = inspector.getCheckpointColumn(0);
            if (checkpointColumn == null) {
                return;
            }
            String filter = "";
            if (checkpointColumn.equals(partitionKey)) {
                filter = "allow filtering";
            }
            Object value = context.getLastUpdateValue();
            HashSet list = new HashSet();
            ResultSet resultSet = sibyl.execute("select " + partitionKey + ", count(*) from " + tableName + " where " + checkpointColumn + " > :spk group by " + partitionKey + " " + filter, (Map<String, Object>)MapBuilder.of((Object)"spk", (Object)value));
            for (Row row : resultSet.all()) {
                list.add(row.get(0, value.getClass()));
            }
            sibyl.createAsync("delete from " + inspector.tableName() + " where " + partitionKey + " = :partitionKey").execute(list, (p, bound) -> bound.set("partitionKey", p, p.getClass())).inExecutionOrder();
        });
    }

    public void analyze(PartitionContext context) {
        this.descriptors.clear();
        for (Class<?> cls = this.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (method.getAnnotation(Loader.class) != null) {
                    this.setupLoader(method);
                }
                if (method.getAnnotation(PartitionLoader.class) == null) continue;
                this.setupPartitionLoader(method);
            }
        }
        Collections.sort(this.descriptors, Comparator.comparingInt(p -> p.order));
        for (Descriptor entry : this.descriptors) {
            entry.context.setStartTime(context.getStartTime());
            entry.context.setProvision(context.getProvision());
            entry.context.setBatchSize(context.getBatchSize());
            entry.context.setExtractAll(context.isExtractAll());
            entry.context.setTimeLag(context.getTimeLag());
            entry.context.setMaxPast(context.getTimeLag());
            entry.context.setMaxTimeUnitSteps(context.getMaxTimeUnitSteps());
            entry.context.setRetries(context.getRetries());
            entry.context.setRetrySleep(context.getRetrySleep());
            if (entry.settings == null) continue;
            ETLSettings s = entry.settings;
            if (s.getStartTime() != null) {
                entry.context.setStartTime(s.getStartTime());
            }
            if (s.getBatchSize() != null) {
                entry.context.setBatchSize(s.getBatchSize());
            }
            if (s.getExtractAll() != null) {
                entry.context.setExtractAll(s.getExtractAll());
            }
            if (s.getTimeLag() != null) {
                entry.context.setTimeLag(s.getTimeLag());
            }
            if (s.getMaxPast() != null) {
                entry.context.setMaxPast(s.getMaxPast());
            }
            if (s.getMaxTimeUnitSteps() != null) {
                entry.context.setMaxTimeUnitSteps(s.getMaxTimeUnitSteps());
            }
            if (s.getRetries() != null) {
                entry.context.setRetries(s.getRetries());
            }
            if (s.getRetrySleep() == null) continue;
            entry.context.setRetrySleep(s.getRetrySleep());
        }
    }

    private void setupLoader(Method method) {
        Loader loader = method.getAnnotation(Loader.class);
        this.setupContext(loader.value(), method, null, RunType.EACH_ENTRY);
    }

    private void setupPartitionLoader(Method method) {
        PartitionLoader loader = method.getAnnotation(PartitionLoader.class);
        this.setupContext(loader.value(), method, loader.sourceClass(), RunType.PARTITION);
    }

    private void setupContext(int order, Method method, Class src, RunType runType) {
        if (!method.getReturnType().equals(Integer.TYPE)) {
            throw new SystemException("Invalid return type for method " + method + ", expecting int");
        }
        if (method.getParameterTypes().length != 2) {
            throw new SystemException("Invalid number of parameters for method " + method + ", expecting 2");
        }
        Class<?> ptype = method.getParameterTypes()[1];
        if (!ptype.isArray()) {
            throw new SystemException("Invalid signature for method " + method + ", expecting array type for argument 2.");
        }
        Class sourceClass = this.extractorSourceClass(order, method, src);
        Class componentType = this.extractorComponentClass(order, method, src);
        try {
            if (!Partition.class.isAssignableFrom(sourceClass)) {
                throw new SystemException("Source class " + sourceClass + " does not implement Partition inteface");
            }
            PartitionContext context = PartitionContext.createContext(null, sourceClass);
            if (!method.getParameterTypes()[0].isAssignableFrom(context.getClass())) {
                throw new SystemException("Invalid loader (" + this.getClass() + ") argument type declaration for method " + method + ": expecting " + context.getClass() + " but declared as " + method.getParameterTypes()[0]);
            }
            PartitionStrategy strategy = context.createStrategy();
            context.setExtractorName(this.extractorName(sourceClass));
            context.setLoadDelegate(list -> {
                try {
                    return (Integer)method.invoke((Object)this, context, list.toArray((Object[])Array.newInstance(componentType, 0)));
                }
                catch (Exception e) {
                    throw new SystemException("Unable to invoke " + method, (Throwable)e);
                }
            });
            ETLSettings s = this.settings.get("" + order);
            Descriptor entry = new Descriptor(order, context, strategy, runType, s);
            this.descriptors.addLast(entry);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected Class extractorSourceClass(int order, Method method, Class src) {
        Class<?> ptype = method.getParameterTypes()[1];
        return src != null ? src : ptype.getComponentType();
    }

    protected Class extractorComponentClass(int order, Method method, Class src) {
        Class<?> ptype = method.getParameterTypes()[1];
        return ptype.getComponentType();
    }

    protected String extractorName(Class sourceClass) {
        return sourceClass.getName() + "_" + this.getClass().getSimpleName();
    }

    public List<Descriptor> describe() {
        return this.descriptors;
    }

    @Override
    public int run(PartitionContext context) {
        context.setSourceClass(this.getClass());
        this.analyze(context);
        int count = 0;
        if (this.customizer != null) {
            for (Descriptor entry : this.descriptors) {
                this.customizer.customize(context, entry);
            }
        }
        block9: for (Descriptor entry : this.descriptors) {
            int retries = context.getRetries();
            while (true) {
                try {
                    switch (entry.runType) {
                        case EACH_ENTRY: {
                            count += entry.strategy.run(entry.context);
                            break;
                        }
                        case PARTITION: {
                            count += entry.strategy.runPartitions(entry.context);
                        }
                    }
                    continue block9;
                }
                catch (Exception ex) {
                    String info = "";
                    if (entry.context != null) {
                        info = "extractor=" + entry.context.extractor() + " sourceClass=" + entry.context.getSourceClass() + " tableName=" + entry.context.tableName();
                    }
                    if (retries <= 0) {
                        logger.warn("Cannot transmutate " + info, (Throwable)ex);
                        throw ex;
                    }
                    logger.warn("Cannot transmutate, " + retries + " retry attempts left, " + info, (Throwable)ex);
                    try {
                        Thread.sleep(context.getRetrySleep());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --retries;
                    continue;
                }
                break;
            }
        }
        return count;
    }

    private static enum RunType {
        EACH_ENTRY,
        PARTITION;

    }

    public static interface Customizer {
        public void customize(PartitionContext var1, Descriptor var2);
    }

    public static class Descriptor {
        public int order;
        public PartitionContext context;
        public PartitionStrategy strategy;
        public RunType runType;
        public ETLSettings settings;

        Descriptor(int order, PartitionContext context, PartitionStrategy strategy, RunType runType, ETLSettings settings) {
            this.order = order;
            this.context = context;
            this.strategy = strategy;
            this.runType = runType;
            this.settings = settings;
        }
    }
}

