/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.driver.cql.BaseResultSet;
import net.e6tech.elements.cassandra.driver.cql.Row;
import net.e6tech.elements.cassandra.driver.v4.Mapper;
import net.e6tech.elements.cassandra.driver.v4.MappingManager;
import net.e6tech.elements.cassandra.driver.v4.ResultSetV4;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.common.inject.Inject;

public class SibylV4
extends Sibyl {
    private MappingManager mappingManager;

    public MappingManager getMappingManager() {
        return this.mappingManager;
    }

    @Inject
    public void setMappingManager(MappingManager mappingManager) {
        this.mappingManager = mappingManager;
    }

    private WriteOptions writeOptions(WriteOptions userOptions) {
        WriteOptions options = WriteOptions.from(userOptions);
        return options.merge(this.getWriteOptions());
    }

    private ReadOptions readOptions(ReadOptions userOptions) {
        ReadOptions options = ReadOptions.from(userOptions);
        return options.merge(this.getReadOptions());
    }

    @Override
    public String getKeyspace() {
        return this.mappingManager.getKeyspace();
    }

    @Override
    public <T> T get(Class<T> cls, PrimaryKey primaryKey) {
        return this.get(cls, primaryKey, null);
    }

    @Override
    public <T> T get(Class<T> cls, PrimaryKey primaryKey, ReadOptions readOptions) {
        return this.mappingManager.getMapper(cls).get(this.readOptions(readOptions), primaryKey.getKeys());
    }

    @Override
    public <X> AsyncFutures<X, PrimaryKey> get(Collection<PrimaryKey> list, Class<X> cls, ReadOptions userOptions) {
        Async async = this.createAsync();
        Mapper mapper = this.mappingManager.getMapper(cls);
        return async.accept(list, item -> mapper.getAsync(this.readOptions(userOptions), item.getKeys()).toCompletableFuture());
    }

    @Override
    public <T> void save(Class<T> cls, T entity) {
        this.save(cls, entity, null);
    }

    @Override
    public <T> void save(Class<T> cls, T entity, WriteOptions options) {
        this.mappingManager.getMapper(cls).save(this.writeOptions(options), entity);
    }

    @Override
    public <T> void delete(Class<T> cls, T entity) {
        this.mappingManager.getMapper(cls).delete(entity);
    }

    @Override
    public <X> void save(Collection<X> list, Class<X> cls) {
        this.save(list, cls, null);
    }

    @Override
    public <X> void save(Collection<X> list, Class<X> cls, WriteOptions userOptions) {
        Async async = this.createAsync();
        Mapper mapper = this.mappingManager.getMapper(cls);
        AsyncFutures futures = async.accept(list, item -> mapper.saveAsync(this.writeOptions(userOptions), item).toCompletableFuture());
        if (userOptions != null && userOptions.timeout != null && userOptions.timeout > 0L) {
            futures.timeout(userOptions.timeout);
        }
        futures.inExecutionOrder();
    }

    @Override
    public <X> X one(Class<X> cls, String query, Map<String, Object> map) {
        net.e6tech.elements.cassandra.driver.cql.ResultSet resultSet = this.execute(query, map);
        ResultSet rs = (ResultSet)((ResultSetV4)resultSet).unwrap();
        return this.mappingManager.getMapper(cls).one(rs);
    }

    @Override
    public <X> List<X> all(Class<X> cls, String query, Map<String, Object> map) {
        return this.mapAll(cls, this.execute(query, map));
    }

    @Override
    public <X> List<X> mapAll(Class<X> cls, BaseResultSet resultSet) {
        Mapper<X> mapper = this.mappingManager.getMapper(cls);
        List<Row> all = resultSet.all();
        LinkedList<X> list = new LinkedList<X>();
        for (Row row : all) {
            list.add(mapper.map(row));
        }
        return list;
    }
}

