/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.async.AsyncResultSetFutures;
import net.e6tech.elements.cassandra.driver.cql.AsyncResultSet;
import net.e6tech.elements.cassandra.driver.cql.Bound;
import net.e6tech.elements.cassandra.driver.cql.Prepared;
import net.e6tech.elements.common.resources.Provision;

public class AsyncPrepared<D>
extends Async<AsyncResultSet, D> {
    private static Cache<String, Prepared> preparedStatementCache = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(200).maximumSize(500L).build();
    private Prepared prepared;

    @Override
    protected AsyncFutures<AsyncResultSet, D> createResult() {
        return new AsyncResultSetFutures((Async)this, this.futures);
    }

    public AsyncResultSetFutures<D> getResult() {
        return (AsyncResultSetFutures)super.getResult();
    }

    public AsyncPrepared<D> prepare(String stmt) {
        try {
            return this.prepare((Prepared)preparedStatementCache.get((Object)stmt, () -> this.session.prepare(stmt)));
        }
        catch (ExecutionException e) {
            return this.prepare(this.session.prepare(stmt));
        }
    }

    public AsyncPrepared<D> prepare(Prepared stmt) {
        this.prepared = stmt;
        return this;
    }

    public AsyncResultSetFutures<D> execute(Consumer<Bound> consumer) {
        return this.execute(null, consumer);
    }

    public AsyncResultSetFutures<D> execute(D data, Consumer<Bound> consumer) {
        Bound bound = this.prepared.bind();
        consumer.accept(bound);
        Future<AsyncResultSet> future = this.session.executeAsync(bound);
        this.futures.add(future);
        if (data != null) {
            this.futuresData.put(future, data);
        }
        return this.getResult();
    }

    public AsyncResultSetFutures<D> execute(Collection<D> collection, BiConsumer<D, Bound> biConsumer) {
        this.resizeFuturesData(collection.size());
        for (Object t : collection) {
            this.execute(t, (Bound boundStatement) -> biConsumer.accept(t, (Bound)boundStatement));
        }
        return this.getResult();
    }

    public AsyncResultSetFutures<D> execute(D[] array, BiConsumer<D, Bound> biConsumer) {
        this.resizeFuturesData(array.length);
        for (Object t : array) {
            this.execute(t, (Bound boundStatement) -> biConsumer.accept(t, (Bound)boundStatement));
        }
        return this.getResult();
    }
}

