/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.List;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.etl.BatchStrategy;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.etl.TimeBatch;

public interface TimeBatchStrategy<S>
extends BatchStrategy<S, TimeBatch> {
    @Override
    default public List<S> extract(TimeBatch context) {
        LastUpdate lastUpdate = context.getLastUpdate();
        return this.extractUpdate(context, lastUpdate);
    }

    public List<S> extractUpdate(TimeBatch var1, LastUpdate var2);

    @Override
    default public int run(TimeBatch context) {
        if (context.getSourceClass() == null) {
            throw new IllegalStateException("sourceClass not set in context");
        }
        return (Integer)context.open().apply(Sibyl.class, sibyl -> {
            List<S> batchResults;
            this.initializeContext(context);
            LastUpdate lastUpdate = context.getLastUpdate();
            int importedCount = 0;
            logger.info("Loading Class {}", this.getClass());
            while (!(batchResults = this.extract(context)).isEmpty()) {
                int n = context.getImportedCount();
                int processedCount = this.load(context, batchResults);
                context.setImportedCount(n + processedCount);
                context.saveLastUpdate(lastUpdate);
                logger.info("Processed {} instance of {}", (Object)processedCount, this.getClass());
                importedCount += processedCount;
            }
            logger.info("Done loading {} instance of {}", (Object)importedCount, this.getClass());
            return importedCount;
        });
    }

    default public void initializeContext(TimeBatch context) {
        context.initialize();
        LastUpdate lastUpdate = context.getLastUpdate();
        long lastImport = Long.parseLong(lastUpdate.getLastUpdate());
        long start = System.currentTimeMillis();
        context.setEnd(start - context.getTimeLag());
        context.setStart(lastImport);
    }
}

