/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.e6tech.elements.cassandra.driver.datatype.SetType;
import net.e6tech.elements.cassandra.driver.metadata.AbstractColumnMetadata;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.TypeDescriptorImpl;

public class ColumnMetadataV4
extends AbstractColumnMetadata {
    public ColumnMetadataV4(Generator generator, ColumnMetadata metadata) {
        this.setName(metadata.getName().toString());
        DataType dataType = metadata.getType();
        net.e6tech.elements.cassandra.driver.datatype.DataType d = ColumnMetadataV4.createDataType(generator, dataType);
        this.setDataType(d);
    }

    protected static net.e6tech.elements.cassandra.driver.datatype.DataType createDataType(Generator generator, DataType dataType) {
        Class type;
        TypeDescriptorImpl impl = new TypeDescriptorImpl();
        switch (dataType.getProtocolCode()) {
            case 1: {
                type = String.class;
                break;
            }
            case 2: {
                type = Long.class;
                break;
            }
            case 3: {
                type = byte[].class;
                break;
            }
            case 4: {
                type = Boolean.class;
                break;
            }
            case 5: {
                type = Long.class;
                break;
            }
            case 6: {
                type = BigDecimal.class;
                break;
            }
            case 7: {
                type = Double.class;
                break;
            }
            case 8: {
                type = Float.class;
                break;
            }
            case 9: {
                type = Integer.class;
                break;
            }
            case 11: {
                type = Instant.class;
                break;
            }
            case 12: {
                type = UUID.class;
                break;
            }
            case 13: {
                type = String.class;
                break;
            }
            case 14: {
                type = BigInteger.class;
                break;
            }
            case 15: {
                type = UUID.class;
                impl.setTimeBased(true);
                break;
            }
            case 16: {
                type = InetAddress.class;
                break;
            }
            case 17: {
                type = LocalDate.class;
                break;
            }
            case 18: {
                type = LocalTime.class;
                break;
            }
            case 19: {
                type = Short.class;
                break;
            }
            case 20: {
                type = Byte.class;
                break;
            }
            case 32: {
                type = List.class;
                break;
            }
            case 33: {
                type = Map.class;
                break;
            }
            case 34: {
                type = Set.class;
                break;
            }
            default: {
                type = null;
            }
        }
        if (type == null) {
            return null;
        }
        net.e6tech.elements.cassandra.driver.datatype.DataType d = net.e6tech.elements.cassandra.driver.datatype.DataType.create(generator, type, impl);
        if (dataType instanceof ListType) {
            ListType l = (ListType)dataType;
            impl.setFrozen(l.isFrozen());
            ((net.e6tech.elements.cassandra.driver.datatype.ListType)d).setComponentType(ColumnMetadataV4.createDataType(generator, l.getElementType()));
        } else if (dataType instanceof com.datastax.oss.driver.api.core.type.SetType) {
            com.datastax.oss.driver.api.core.type.SetType l = (com.datastax.oss.driver.api.core.type.SetType)dataType;
            impl.setFrozen(l.isFrozen());
            ((SetType)d).setComponentType(ColumnMetadataV4.createDataType(generator, l.getElementType()));
        } else if (dataType instanceof MapType) {
            MapType l = (MapType)dataType;
            impl.setFrozen(l.isFrozen());
            ((net.e6tech.elements.cassandra.driver.datatype.MapType)d).setKeyType(ColumnMetadataV4.createDataType(generator, l.getKeyType()));
            ((net.e6tech.elements.cassandra.driver.datatype.MapType)d).setValueType(ColumnMetadataV4.createDataType(generator, l.getValueType()));
        }
        return d;
    }
}

