/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.SettableByName;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.internal.mapper.entity.EntityHelperBase;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultUpdate;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class Helper<T>
extends EntityHelperBase<T> {
    private static final String MISSING_KEY_COLUMNS = "Missing primary key columns for %s.";
    private static final String EMPTY_COLUMNS = "Empty columns for %s.";
    private static final Logger LOG = Logger.getLogger();
    private Class<T> entityClass;
    private Inspector inspector;

    public Helper(MapperContext context, Class<T> entityClass, Inspector inspector) {
        super(context, inspector.tableName(entityClass));
        LOG.debug("[{}] Entity will be mapped to {}{}", new Object[]{context.getSession().getName(), this.getKeyspaceId() == null ? "" : this.getKeyspaceId() + ".", this.getTableId()});
        this.entityClass = entityClass;
        this.inspector = inspector;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public <S extends SettableByName<S>> S set(T entity, S target, NullSavingStrategy nullSavingStrategy) {
        for (Inspector.ColumnAccessor accessor : this.inspector.getColumns()) {
            Object value = accessor.get(entity);
            if (value == null && nullSavingStrategy != NullSavingStrategy.SET_TO_NULL) continue;
            target = target.set(accessor.getColumnName(), value, accessor.getType());
        }
        return target;
    }

    @Nonnull
    public T get(@Nonnull GettableByName source) {
        T returnValue;
        try {
            returnValue = this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        for (Inspector.ColumnAccessor accessor : this.inspector.getColumns()) {
            accessor.set(returnValue, source.get(accessor.getColumnName(), accessor.getType()));
        }
        return returnValue;
    }

    @Nonnull
    public RegularInsert insert() {
        this.throwIfKeyspaceMissing();
        InsertInto insertInto = this.keyspaceId == null ? QueryBuilder.insertInto((CqlIdentifier)this.tableId) : QueryBuilder.insertInto((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        RegularInsert regularInsert = null;
        boolean first = true;
        for (Inspector.ColumnAccessor accessor : this.inspector.getColumns()) {
            String column = accessor.getColumnName();
            if (first) {
                first = false;
                regularInsert = insertInto.value(column, (Term)QueryBuilder.bindMarker((String)column));
                continue;
            }
            regularInsert = regularInsert.value(column, (Term)QueryBuilder.bindMarker((String)column));
        }
        if (regularInsert == null) {
            throw new MapperException(String.format(EMPTY_COLUMNS, this.inspector.tableName()));
        }
        return regularInsert;
    }

    @Nonnull
    public Select selectByPrimaryKey() {
        Select selectStart = this.selectStart();
        boolean first = true;
        Select select = null;
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            String column = accessor.getColumnName();
            if (first) {
                first = false;
                select = (Select)selectStart.whereColumn(column).isEqualTo((Term)QueryBuilder.bindMarker((String)column));
                continue;
            }
            select = (Select)select.whereColumn(column).isEqualTo((Term)QueryBuilder.bindMarker((String)column));
        }
        if (select == null) {
            throw new MapperException(String.format(MISSING_KEY_COLUMNS, this.inspector.tableName()));
        }
        return select;
    }

    @Nonnull
    public Select selectStart() {
        this.throwIfKeyspaceMissing();
        SelectFrom selectFrom = this.keyspaceId == null ? QueryBuilder.selectFrom((CqlIdentifier)this.tableId) : QueryBuilder.selectFrom((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        Select select = null;
        boolean first = true;
        for (Inspector.ColumnAccessor accessor : this.inspector.getColumns()) {
            String column = accessor.getColumnName();
            if (first) {
                first = false;
                select = selectFrom.column(column);
                continue;
            }
            select = select.column(column);
        }
        if (select == null) {
            throw new MapperException(String.format(EMPTY_COLUMNS, this.inspector.tableName()));
        }
        return select;
    }

    @Nonnull
    public Delete deleteByPrimaryKey() {
        this.throwIfKeyspaceMissing();
        DeleteSelection deleteFrom = this.keyspaceId == null ? QueryBuilder.deleteFrom((CqlIdentifier)this.tableId) : QueryBuilder.deleteFrom((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        Delete delete = null;
        boolean first = true;
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            String column = accessor.getColumnName();
            if (first) {
                first = false;
                delete = (Delete)deleteFrom.whereColumn(column).isEqualTo((Term)QueryBuilder.bindMarker((String)column));
                continue;
            }
            delete = (Delete)delete.whereColumn(column).isEqualTo((Term)QueryBuilder.bindMarker((String)column));
        }
        if (delete == null) {
            throw new MapperException(String.format(MISSING_KEY_COLUMNS, this.inspector.tableName()));
        }
        return delete;
    }

    @Nonnull
    public DefaultUpdate updateStart() {
        this.throwIfKeyspaceMissing();
        UpdateStart updateSt = this.keyspaceId == null ? QueryBuilder.update((CqlIdentifier)this.tableId) : QueryBuilder.update((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        HashSet<String> keyColumns = new HashSet<String>();
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            keyColumns.add(accessor.getColumnName());
        }
        DefaultUpdate update = null;
        boolean first = true;
        for (Inspector.ColumnAccessor accessor : this.inspector.getColumns()) {
            String column = accessor.getColumnName();
            if (keyColumns.contains(column)) continue;
            if (first) {
                first = false;
                update = (DefaultUpdate)updateSt.setColumn(column, (Term)QueryBuilder.bindMarker((String)column));
                continue;
            }
            update = (DefaultUpdate)update.whereColumn(column).isEqualTo((Term)QueryBuilder.bindMarker((String)column));
        }
        if (update == null) {
            throw new MapperException(String.format(EMPTY_COLUMNS, this.inspector.tableName()));
        }
        return update;
    }

    @Nonnull
    public DefaultUpdate updateByPrimaryKey() {
        DefaultUpdate update = null;
        boolean first = true;
        for (Inspector.ColumnAccessor accessor : this.inspector.getPrimaryKeyColumns()) {
            String column = accessor.getColumnName();
            if (first) {
                first = false;
                update = (DefaultUpdate)this.updateStart().where((Relation)Relation.column((String)("\"" + column + "\"")).isEqualTo((Term)QueryBuilder.bindMarker((String)("\"" + column + "\""))));
                continue;
            }
            update = (DefaultUpdate)update.where((Relation)Relation.column((String)("\"" + column + "\"")).isEqualTo((Term)QueryBuilder.bindMarker((String)("\"" + column + "\""))));
        }
        if (update == null) {
            throw new MapperException(String.format(MISSING_KEY_COLUMNS, this.inspector.tableName()));
        }
        return update;
    }

    public void validateEntityFields() {
    }
}

