/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.e6tech.elements.cassandra.driver.datatype.DataType;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;

public class ColumnGenerator {
    private DataType dataType;
    private TypeDescriptor typeDescriptor;
    private PropertyDescriptor propertyDescriptor;
    private Field field;

    public ColumnGenerator(Generator generator, PropertyDescriptor descriptor, Type type, TypeDescriptor typeDescriptor) {
        this.dataType = DataType.create(generator, type, typeDescriptor);
        this.typeDescriptor = typeDescriptor;
        this.propertyDescriptor = descriptor;
    }

    public ColumnGenerator(Generator generator, Field field, Type type, TypeDescriptor typeDescriptor) {
        this.dataType = DataType.create(generator, type, typeDescriptor);
        this.typeDescriptor = typeDescriptor;
        this.field = field;
    }

    public String generate() {
        return "\"" + this.typeDescriptor.getColumnName() + "\" " + this.dataType.getTypeString();
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Field getField() {
        return this.field;
    }
}

