/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.internal.mapper.DefaultMapperContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.driver.v4.Mapper;
import net.e6tech.elements.cassandra.driver.v4.MapperImpl;
import net.e6tech.elements.cassandra.etl.Inspector;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class MappingManager {
    protected final SessionProvider sessionProvider;
    protected final CqlSession session;
    private String keyspace;
    private ConcurrentMap<Class, MapperBuilder> builders = new ConcurrentHashMap();

    public MappingManager(SessionProvider sessionProvider, CqlSession session, String keyspace) {
        this.sessionProvider = sessionProvider;
        this.session = session;
        this.keyspace = keyspace;
        if (keyspace == null) {
            this.keyspace = session.getKeyspace().map(CqlIdentifier::asInternal).orElse(null);
        }
    }

    public <T> Mapper<T> getMapper(Class<T> cls) {
        MapperBuilder builder = this.builders.computeIfAbsent(cls, key -> {
            MapperBuilder b = new MapperBuilder();
            return b.build(cls, this.keyspace);
        });
        return builder.getMapper();
    }

    private class MapperBuilder<T> {
        protected Map<Object, Object> customState = new HashMap<Object, Object>();
        private LazyReference<Mapper<T>> cache;

        protected MapperBuilder() {
        }

        @NonNull
        public MapperBuilder withCustomState(@Nullable Object key, @Nullable Object value) {
            this.customState.put(key, value);
            return this;
        }

        public MapperBuilder build(Class cls, String keyspace) {
            Inspector inspector = MappingManager.this.sessionProvider.getInspector(cls);
            CqlIdentifier tableId = CqlIdentifier.fromInternal((String)inspector.tableName());
            CqlIdentifier keyspaceId = CqlIdentifier.fromInternal((String)keyspace);
            DefaultMapperContext context = new DefaultMapperContext(MappingManager.this.session, this.customState).withKeyspaceAndTable(keyspaceId, tableId);
            this.cache = new LazyReference(() -> MapperImpl.init((MapperContext)context, cls, inspector));
            return this;
        }

        public Mapper<T> getMapper() {
            return (Mapper)this.cache.get();
        }
    }
}

