/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.cassandra.generator.ColumnInfo;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.KeyColumn;

public class TableAnalyzer {
    private Map<String, ColumnInfo> columns = new LinkedHashMap<String, ColumnInfo>();
    private List<KeyColumn> clusteringKeys = new ArrayList<KeyColumn>();
    private List<KeyColumn> partitionKeys = new ArrayList<KeyColumn>();
    private String tableName;
    private String tableKeyspace;

    public TableAnalyzer(Generator generator, Class entityClass) throws IntrospectionException {
        LinkedList<Class> classHierarchy = this.analyze(generator, entityClass);
        Set<String> transientNames = this.collectionTransient(generator, entityClass, classHierarchy);
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            this.analyzeProperty(generator, desc, transientNames);
        }
        for (Class cls : classHierarchy) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                this.analyzeField(generator, field, transientNames);
            }
        }
        this.partitionKeys.removeIf(keyColumn -> keyColumn.getPosition() < 0);
        this.clusteringKeys.removeIf(keyColumn -> keyColumn.getPosition() < 0);
        Collections.sort(this.partitionKeys, Comparator.comparingInt(KeyColumn::getPosition));
        Collections.sort(this.clusteringKeys, Comparator.comparingInt(KeyColumn::getPosition));
    }

    private Set<String> collectionTransient(Generator generator, Class entityClass, List<Class> classHierarchy) throws IntrospectionException {
        HashSet<String> transientNames = new HashSet<String>(50);
        for (Class cls : classHierarchy) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (Modifier.isStrict(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !generator.isTransient(field)) continue;
                transientNames.add(generator.getColumnName(field));
            }
        }
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            if (!generator.isTransient(desc)) continue;
            transientNames.add(generator.getColumnName(desc));
        }
        return transientNames;
    }

    private void analyzeProperty(Generator generator, PropertyDescriptor desc, Set<String> transientNames) {
        Method method = null;
        Type type = null;
        if (desc.getReadMethod() != null) {
            method = desc.getReadMethod();
            type = method.getGenericReturnType();
        }
        if (method == null && desc.getWriteMethod() != null) {
            method = desc.getWriteMethod();
            type = method.getGenericParameterTypes()[0];
        }
        if (method != null && !desc.getName().equals("class")) {
            if (transientNames.contains(generator.getColumnName(desc))) {
                return;
            }
            generator.partitionKeyIndex(desc, pk -> this.addKey(this.partitionKeys, generator.getColumnName(desc), pk, desc, null));
            generator.clusteringColumnIndex(desc, cc -> this.addKey(this.clusteringKeys, generator.getColumnName(desc), cc, desc, null));
            ColumnInfo column = this.columns.get(generator.getColumnName(desc));
            if (column == null) {
                this.columns.put(generator.getColumnName(desc), new ColumnInfo(generator.getColumnName(desc), type, desc, null));
            } else if (column.getPropertyDescriptor() == null) {
                column.setPropertyDescriptor(desc);
            }
        }
    }

    private void analyzeField(Generator generator, Field field, Set<String> transientNames) {
        if (Modifier.isStrict(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || transientNames.contains(generator.getColumnName(field))) {
            return;
        }
        generator.partitionKeyIndex(field, pk -> this.addKey(this.partitionKeys, generator.getColumnName(field), pk, null, field));
        generator.clusteringColumnIndex(field, cc -> this.addKey(this.clusteringKeys, generator.getColumnName(field), cc, null, field));
        ColumnInfo column = this.columns.get(generator.getColumnName(field));
        if (column == null) {
            this.columns.put(generator.getColumnName(field), new ColumnInfo(generator.getColumnName(field), field.getGenericType(), null, field));
        } else if (column.getField() == null) {
            column.setField(field);
        }
    }

    private void addKey(List<KeyColumn> columns, String columnName, int index, PropertyDescriptor descriptor, Field field) {
        boolean exist = false;
        for (KeyColumn keyColumn : columns) {
            if (!keyColumn.getName().equals(columnName) && (keyColumn.getPosition() < 0 || keyColumn.getPosition() != index)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            columns.add(new KeyColumn(columnName, index, descriptor, field));
        }
    }

    protected LinkedList<Class> analyze(Generator generator, Class entityClass) {
        if (entityClass == null) {
            return new LinkedList<Class>();
        }
        LinkedList<Class> classHierarchy = new LinkedList<Class>();
        for (Class tmp = entityClass; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (generator.tableAnnotation(tmp) != null) {
                if (this.tableName == null) {
                    this.tableName = generator.tableName(tmp);
                }
                if (this.tableKeyspace == null) {
                    this.tableKeyspace = generator.tableKeyspace(tmp);
                }
            }
            classHierarchy.addFirst(tmp);
        }
        return classHierarchy;
    }

    public List<KeyColumn> getPartitionKeys() {
        return this.partitionKeys;
    }

    public List<KeyColumn> getClusteringKeys() {
        return this.clusteringKeys;
    }

    public Map<String, ColumnInfo> getColumns() {
        return this.columns;
    }
}

