/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.driver.metadata.ColumnMetadata;
import net.e6tech.elements.cassandra.driver.metadata.TableMetadata;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.AnnotatedTypeDescriptor;
import net.e6tech.elements.cassandra.generator.ColumnGenerator;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.KeyColumn;
import net.e6tech.elements.cassandra.generator.TableAnalyzer;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;
import net.e6tech.elements.common.logging.Logger;

public class TableGenerator
extends AbstractGenerator {
    private static Logger logger = Logger.getLogger();
    private TableAnalyzer analyzer;
    private Map<String, ColumnGenerator> columnGenerators = new LinkedHashMap<String, ColumnGenerator>();

    TableGenerator(Generator generator, Class entityClass) throws IntrospectionException {
        super(generator);
        this.analyze(entityClass);
        this.analyzer = new TableAnalyzer(generator, entityClass);
        this.analyzer.getColumns().forEach((columnName, column) -> {
            if (column.getPropertyDescriptor() != null) {
                AnnotatedTypeDescriptor typeDescriptor = new AnnotatedTypeDescriptor(generator, column.getPropertyDescriptor());
                if (column.getField() != null) {
                    typeDescriptor.setParent(new AnnotatedTypeDescriptor(generator, column.getField()));
                }
                this.columnGenerators.put((String)columnName, new ColumnGenerator(generator, column.getPropertyDescriptor(), column.getType(), (TypeDescriptor)typeDescriptor));
            } else {
                this.columnGenerators.put((String)columnName, new ColumnGenerator(generator, column.getField(), column.getField().getGenericType(), (TypeDescriptor)new AnnotatedTypeDescriptor(generator, column.getField())));
            }
        });
    }

    public List<KeyColumn> getPartitionKeys() {
        return this.analyzer.getPartitionKeys();
    }

    public List<KeyColumn> getClusteringKeys() {
        return this.analyzer.getClusteringKeys();
    }

    public Map<String, ColumnGenerator> getColumns() {
        return this.columnGenerators;
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS ").append(this.fullyQualifiedTableName()).append(" (\n");
        for (ColumnGenerator gen : this.getColumns().values()) {
            builder.append(gen.generate());
            builder.append(",\n");
        }
        boolean first = true;
        builder.append("PRIMARY KEY (");
        if (this.analyzer.getPartitionKeys().size() > 1) {
            builder.append("(");
        }
        for (KeyColumn pk : this.analyzer.getPartitionKeys()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("\"" + pk.getName() + "\"");
        }
        if (this.analyzer.getPartitionKeys().size() > 1) {
            builder.append(")");
        }
        for (KeyColumn cc : this.analyzer.getClusteringKeys()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("\"" + cc.getName() + "\"");
        }
        builder.append(")\n").append(") ").append(this.getTableCompression());
        return builder.toString();
    }

    public void diff(Session session, String keyspace, TableMetadata tableMetadata, boolean dropColumns) {
        if (logger.isInfoEnabled()) {
            logger.info("Diff table {}", (Object)this.fullyQualifiedTableName());
        }
        List<ColumnMetadata> columns = tableMetadata.getColumns();
        LinkedHashMap<String, ColumnGenerator> toAdd = new LinkedHashMap<String, ColumnGenerator>();
        LinkedHashMap<String, ColumnMetadata> toRemove = new LinkedHashMap<String, ColumnMetadata>();
        for (ColumnGenerator gen : this.getColumns().values()) {
            toAdd.put(gen.getTypeDescriptor().getColumnName().toLowerCase(), gen);
        }
        for (ColumnMetadata meta : columns) {
            toRemove.put(meta.getName().toLowerCase(), meta);
        }
        for (ColumnMetadata meta : columns) {
            toAdd.remove(meta.getName().toLowerCase());
        }
        for (ColumnGenerator gen : this.getColumns().values()) {
            toRemove.remove(gen.getTypeDescriptor().getColumnName().toLowerCase());
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Object col : toAdd.values()) {
            builder.append("ALTER TABLE ");
            builder.append(this.fullyQualifiedTableName());
            builder.append(" ADD ");
            builder.append(((ColumnGenerator)col).generate());
            session.execute(keyspace, builder.toString());
            builder.setLength(0);
        }
        if (dropColumns) {
            for (Object col : toRemove.values()) {
                builder.append("ALTER TABLE ");
                builder.append(this.fullyQualifiedTableName());
                builder.append(" DROP ");
                builder.append("\"" + col.getName() + "\"");
                session.execute(keyspace, builder.toString());
                builder.setLength(0);
            }
        }
    }
}

