/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.cassandra.annotations.Checkpoint;
import net.e6tech.elements.cassandra.annotations.Index;
import net.e6tech.elements.cassandra.annotations.Indexes;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.Generator;

public class IndexGenerator
extends AbstractGenerator {
    private Map<String, Checkpoint> implicitIndexes = new LinkedHashMap<String, Checkpoint>();
    private Set<String> partitionKeys = new HashSet<String>();
    private Map<String, Index> indexes = new LinkedHashMap<String, Index>();

    IndexGenerator(Generator generator, Class entityClass) throws IntrospectionException {
        super(generator);
        LinkedList<Class> classHierarchy = this.analyze(entityClass);
        HashSet<String> transientNames = new HashSet<String>(50);
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            Method method = null;
            if (desc.getReadMethod() != null) {
                method = desc.getReadMethod();
            }
            if (method == null) {
                throw new IllegalArgumentException("Entity class does not have a get method for property " + desc.getName());
            }
            if (desc.getName().equals("class")) continue;
            if (generator.isTransient(desc)) {
                transientNames.add(desc.getName());
                continue;
            }
            if (transientNames.contains(desc.getName())) continue;
            generator.partitionKeyIndex(desc, pk -> {
                this.partitionKeys.add(generator.getColumnName(desc));
                this.partitionKeys.add(desc.getName());
            });
            if (!this.partitionKeys.contains(desc.getName()) && !this.partitionKeys.contains(generator.getColumnName(desc))) continue;
        }
        for (Class cls : classHierarchy) {
            Indexes indexList = cls.getAnnotation(Indexes.class);
            if (indexList == null) continue;
            for (Index index : indexList.value()) {
                if (index.name().isEmpty()) {
                    this.indexes.put(index.column() + "_idx", index);
                    continue;
                }
                this.indexes.put(index.name(), index);
            }
        }
        for (Class cls : classHierarchy) {
            Field[] fields = cls.getDeclaredFields();
            for (Field field : fields) {
                if (Modifier.isStrict(field.getModifiers())) continue;
                if (generator.isTransient(field)) {
                    transientNames.add(field.getName());
                    continue;
                }
                if (!generator.partitionKeyIndex(field, pk -> {
                    this.partitionKeys.add(generator.getColumnName(field));
                    this.partitionKeys.add(field.getName());
                })) continue;
            }
        }
    }

    public List<String> generate() {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            Index index = entry.getValue();
            builder.append("CREATE INDEX IF NOT EXISTS ");
            builder.append(this.getTableName()).append("__").append(entry.getKey());
            builder.append(" ON ");
            builder.append(this.fullyQualifiedTableName());
            builder.append("(");
            if (index.keys()) {
                builder.append("KEYS(");
            }
            builder.append(index.column());
            if (index.keys()) {
                builder.append(")");
            }
            builder.append(")");
            statements.add(builder.toString());
            builder.setLength(0);
        }
        for (String column : this.implicitIndexes.keySet()) {
            builder.append("CREATE CUSTOM INDEX IF NOT EXISTS ");
            builder.append(this.getTableName()).append("__").append(column).append("_idx");
            builder.append(" ON ");
            builder.append(this.fullyQualifiedTableName());
            builder.append("(");
            builder.append(column);
            builder.append(") USING 'org.apache.cassandra.index.sasi.SASIIndex' WITH OPTIONS = {'mode' : 'SPARSE'} ");
            statements.add(builder.toString());
            builder.setLength(0);
        }
        return statements;
    }
}

