/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import net.e6tech.elements.cassandra.annotations.TimeBased;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;
import net.e6tech.elements.common.reflection.Accessor;

public class AnnotatedTypeDescriptor
implements TypeDescriptor {
    private AnnotatedTypeDescriptor parent;
    private AccessibleObject accessibleObject;
    private PropertyDescriptor descriptor;
    private String columnName;
    private Generator generator;

    public AnnotatedTypeDescriptor(Generator generator, Field field) {
        this.generator = generator;
        this.accessibleObject = field;
        this.columnName = generator.getColumnName(field);
    }

    public AnnotatedTypeDescriptor(Generator generator, PropertyDescriptor descriptor) {
        this.generator = generator;
        this.descriptor = descriptor;
        this.columnName = generator.getColumnName(descriptor);
    }

    public AnnotatedTypeDescriptor getParent() {
        return this.parent;
    }

    public void setParent(AnnotatedTypeDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public boolean isFrozen() {
        if (this.generator.isFrozen(this.descriptor) || this.generator.isFrozen(this.accessibleObject)) {
            return true;
        }
        if (this.parent != null) {
            this.parent.isFrozen();
        }
        return false;
    }

    @Override
    public boolean isFrozenKey() {
        if (this.generator.isFrozenKey(this.descriptor) || this.generator.isFrozenKey(this.accessibleObject)) {
            return true;
        }
        if (this.parent != null) {
            this.parent.isFrozenKey();
        }
        return false;
    }

    @Override
    public boolean isFrozenValue() {
        if (this.generator.isFrozenValue(this.descriptor) || this.generator.isFrozenValue(this.accessibleObject)) {
            return true;
        }
        if (this.parent != null) {
            this.parent.isFrozenValue();
        }
        return false;
    }

    @Override
    public boolean isTimeBased() {
        if (Accessor.getAnnotation((PropertyDescriptor)this.descriptor, (AccessibleObject)this.accessibleObject, TimeBased.class) != null) {
            return true;
        }
        if (this.parent != null) {
            this.parent.isTimeBased();
        }
        return false;
    }

    @Override
    public String getColumnName() {
        if (this.generator.hasColumnAnnotation(this.descriptor) || this.generator.hasColumnAnnotation(this.accessibleObject)) {
            return this.columnName;
        }
        if (this.parent != null && (this.generator.hasColumnAnnotation(this.parent.descriptor) || this.generator.hasColumnAnnotation(this.parent.accessibleObject))) {
            return this.parent.getColumnName();
        }
        return this.columnName;
    }
}

