/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.driver.Wrapper;
import net.e6tech.elements.cassandra.driver.cql.Bound;
import net.e6tech.elements.cassandra.driver.cql.Prepared;
import net.e6tech.elements.cassandra.driver.cql.ResultSet;
import net.e6tech.elements.cassandra.driver.v4.AsyncResultSetV4;
import net.e6tech.elements.cassandra.driver.v4.BoundV4;
import net.e6tech.elements.cassandra.driver.v4.PreparedV4;
import net.e6tech.elements.cassandra.driver.v4.ResultSetV4;
import net.e6tech.elements.common.util.StringUtil;

public class SessionV4
extends Wrapper<CqlSession>
implements Session {
    @Override
    public ResultSet execute(String query) {
        return Wrapper.wrap(new ResultSetV4(), ((CqlSession)this.unwrap()).execute(query));
    }

    @Override
    public ResultSet execute(String keyspace, String query) {
        if (StringUtil.isNullOrEmpty((String)keyspace)) {
            return this.execute(query);
        }
        SimpleStatement stmt = SimpleStatement.newInstance((String)query);
        stmt.setKeyspace(keyspace);
        return Wrapper.wrap(new ResultSetV4(), ((CqlSession)this.unwrap()).execute((Statement)stmt));
    }

    @Override
    public ResultSet execute(Bound bound) {
        return Wrapper.wrap(new ResultSetV4(), ((CqlSession)this.unwrap()).execute((Statement)((BoundV4)bound).unwrap()));
    }

    @Override
    public Future<net.e6tech.elements.cassandra.driver.cql.AsyncResultSet> executeAsync(String keyspace, String query) {
        if (StringUtil.isNullOrEmpty((String)keyspace)) {
            return this.executeAsync(query);
        }
        SimpleStatement stmt = SimpleStatement.newInstance((String)query);
        stmt.setKeyspace(keyspace);
        return new FutureAsyncResultSet(((CqlSession)this.unwrap()).executeAsync((Statement)stmt).toCompletableFuture());
    }

    @Override
    public Future<net.e6tech.elements.cassandra.driver.cql.AsyncResultSet> executeAsync(String query) {
        return new FutureAsyncResultSet(((CqlSession)this.unwrap()).executeAsync(query).toCompletableFuture());
    }

    @Override
    public Future<net.e6tech.elements.cassandra.driver.cql.AsyncResultSet> executeAsync(Bound bound) {
        CompletionStage completionStage = ((CqlSession)this.unwrap()).executeAsync((Statement)((BoundV4)bound).unwrap());
        CompletableFuture<AsyncResultSet> future = completionStage.toCompletableFuture();
        return new FutureAsyncResultSet(future);
    }

    @Override
    public Prepared prepare(String query) {
        return Wrapper.wrap(new PreparedV4(), ((CqlSession)this.unwrap()).prepare(query));
    }

    private static class FutureAsyncResultSet
    implements Future<net.e6tech.elements.cassandra.driver.cql.AsyncResultSet> {
        CompletableFuture<AsyncResultSet> future;

        FutureAsyncResultSet(CompletableFuture<AsyncResultSet> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public net.e6tech.elements.cassandra.driver.cql.AsyncResultSet get() throws InterruptedException, ExecutionException {
            AsyncResultSet rs = this.future.get();
            return Wrapper.wrap(new AsyncResultSetV4(), rs);
        }

        @Override
        public net.e6tech.elements.cassandra.driver.cql.AsyncResultSet get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            AsyncResultSet rs = this.future.get(timeout, unit);
            return Wrapper.wrap(new AsyncResultSetV4(), rs);
        }
    }
}

