/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.driver.metadata.ColumnMetadata;
import net.e6tech.elements.cassandra.driver.metadata.TableMetadata;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.AnnotatedTypeDescriptor;
import net.e6tech.elements.cassandra.generator.ColumnGenerator;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.KeyColumn;
import net.e6tech.elements.common.logging.Logger;

public class TableGenerator
extends AbstractGenerator {
    private static Logger logger = Logger.getLogger();
    private Map<String, ColumnGenerator> columnGenerators = new LinkedHashMap<String, ColumnGenerator>();
    private List<KeyColumn> clusterKeys = new ArrayList<KeyColumn>();
    private List<KeyColumn> partitionKeys = new ArrayList<KeyColumn>();

    TableGenerator(Generator generator, Class entityClass) throws IntrospectionException {
        super(generator);
        LinkedList<Class> classHierarchy = this.analyze(entityClass);
        LinkedHashMap<String, String> columnGenerators2 = new LinkedHashMap<String, String>();
        HashSet<String> transientNames = new HashSet<String>(50);
        for (Class cls : classHierarchy) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                int cc;
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (generator.isTransient(field)) {
                    transientNames.add(field.getName());
                    continue;
                }
                int pk = generator.partitionKeyIndex(field);
                if (pk >= 0) {
                    this.partitionKeys.add(new KeyColumn(generator.getColumnName(field), pk));
                }
                if ((cc = generator.clusteringColumnIndex(field)) >= 0) {
                    this.clusterKeys.add(new KeyColumn(generator.getColumnName(field), cc));
                }
                ColumnGenerator fieldGen = new ColumnGenerator(generator, field.getGenericType(), new AnnotatedTypeDescriptor(generator, field));
                this.columnGenerators.put(generator.getColumnName(field), fieldGen);
                columnGenerators2.put(field.getName(), generator.getColumnName(field));
            }
        }
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            String columnName;
            ColumnGenerator colGen;
            int cc;
            Method method = null;
            Type type = null;
            if (desc.getReadMethod() != null) {
                method = desc.getReadMethod();
                type = method.getGenericReturnType();
            }
            if (type == null && desc.getWriteMethod() != null) {
                method = desc.getWriteMethod();
                type = method.getGenericParameterTypes()[0];
            }
            if (method == null || method.getName().equals("getClass")) continue;
            if (generator.isTransient(desc)) {
                transientNames.add(desc.getName());
                continue;
            }
            if (transientNames.contains(desc.getName())) continue;
            int pk = generator.partitionKeyIndex(desc);
            if (pk >= 0) {
                this.partitionKeys.add(new KeyColumn(generator.getColumnName(desc), pk));
            }
            if ((cc = generator.clusteringColumnIndex(desc)) >= 0) {
                this.clusterKeys.add(new KeyColumn(generator.getColumnName(desc), cc));
            }
            if ((colGen = this.columnGenerators.get(generator.getColumnName(desc))) == null && (columnName = (String)columnGenerators2.get(desc.getName())) != null && (colGen = this.columnGenerators.get(columnName)) != null) {
                this.columnGenerators.remove(columnName);
            }
            AnnotatedTypeDescriptor fieldTypeDescriptor = colGen != null ? (AnnotatedTypeDescriptor)colGen.getTypeDescriptor() : null;
            ColumnGenerator methGen = new ColumnGenerator(generator, type, new AnnotatedTypeDescriptor(generator, desc, fieldTypeDescriptor));
            this.columnGenerators.put(generator.getColumnName(desc), methGen);
        }
    }

    public Map<String, ColumnGenerator> columns() {
        return this.columnGenerators;
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS ");
        builder.append(this.fullyQualifiedTableName());
        builder.append(" (\n");
        for (ColumnGenerator gen : this.columnGenerators.values()) {
            builder.append(gen.generate());
            builder.append(",\n");
        }
        Collections.sort(this.partitionKeys, Comparator.comparingInt(KeyColumn::getPosition));
        Collections.sort(this.clusterKeys, Comparator.comparingInt(KeyColumn::getPosition));
        boolean first = true;
        builder.append("PRIMARY KEY (");
        if (this.partitionKeys.size() > 1) {
            builder.append("(");
        }
        for (KeyColumn pk : this.partitionKeys) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(pk.getName());
        }
        if (this.partitionKeys.size() > 1) {
            builder.append(")");
        }
        for (KeyColumn cc : this.clusterKeys) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(cc.getName());
        }
        builder.append(")\n");
        builder.append(")");
        return builder.toString();
    }

    public void diff(Session session, String keyspace, TableMetadata tableMetadata, boolean dropColumns) {
        if (logger.isInfoEnabled()) {
            logger.info("Diff table {}", (Object)this.fullyQualifiedTableName());
        }
        List<ColumnMetadata> columns = tableMetadata.getColumns();
        LinkedHashMap<String, ColumnGenerator> toAdd = new LinkedHashMap<String, ColumnGenerator>();
        LinkedHashMap<String, ColumnMetadata> toRemove = new LinkedHashMap<String, ColumnMetadata>();
        for (ColumnGenerator gen : this.columnGenerators.values()) {
            toAdd.put(gen.getTypeDescriptor().getColumnName().toLowerCase(), gen);
        }
        for (ColumnMetadata metadata : columns) {
            toRemove.put(metadata.getName().toLowerCase(), metadata);
        }
        for (ColumnMetadata meta : columns) {
            toAdd.remove(meta.getName().toLowerCase());
        }
        for (ColumnGenerator gen : this.columnGenerators.values()) {
            toRemove.remove(gen.getTypeDescriptor().getColumnName().toLowerCase());
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Object col : toAdd.values()) {
            builder.append("ALTER TABLE ");
            builder.append(this.fullyQualifiedTableName());
            builder.append(" ADD ");
            builder.append(((ColumnGenerator)col).generate());
            session.execute(keyspace, builder.toString());
            builder.setLength(0);
        }
        if (dropColumns) {
            for (Object col : toRemove.values()) {
                builder.append("ALTER TABLE ");
                builder.append(this.fullyQualifiedTableName());
                builder.append(" DROP ");
                builder.append(col.getName());
                session.execute(keyspace, builder.toString());
                builder.setLength(0);
            }
        }
    }
}

