/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.e6tech.elements.cassandra.annotations.TimeBased;
import net.e6tech.elements.cassandra.generator.IndexGenerator;
import net.e6tech.elements.cassandra.generator.TableGenerator;
import net.e6tech.elements.common.reflection.Accessor;
import net.e6tech.elements.common.util.SystemException;

public abstract class Generator {
    private Map<String, Class> dataNames = new HashMap<String, Class>();
    private Map<Type, String> dataTypes = new HashMap<Type, String>();

    public Generator() {
        this.dataTypes.put((Type)((Object)Boolean.class), "boolean");
        this.dataTypes.put(Boolean.TYPE, "boolean");
        this.dataTypes.put((Type)((Object)Byte.class), "tinyint");
        this.dataTypes.put(Byte.TYPE, "tinyint");
        this.dataTypes.put((Type)((Object)Long.class), "bigint");
        this.dataTypes.put(Long.TYPE, "bigint");
        this.dataTypes.put((Type)((Object)Integer.class), "int");
        this.dataTypes.put(Integer.TYPE, "int");
        this.dataTypes.put((Type)((Object)BigDecimal.class), "decimal");
        this.dataTypes.put((Type)((Object)Double.class), "double");
        this.dataTypes.put(Double.TYPE, "double");
        this.dataTypes.put((Type)((Object)Float.class), "float");
        this.dataTypes.put(Float.TYPE, "float");
        this.dataTypes.put((Type)((Object)Short.class), "smallint");
        this.dataTypes.put(Short.TYPE, "smallint");
        this.dataTypes.put((Type)((Object)UUID.class), "uuid");
        this.dataTypes.put((Type)((Object)ByteBuffer.class), "blob");
        this.dataTypes.put((Type)((Object)BigInteger.class), "varint");
        this.dataTypes.put((Type)((Object)LocalTime.class), "time");
        this.dataTypes.put((Type)((Object)InetAddress.class), "inet");
        this.dataTypes.put((Type)((Object)LocalDate.class), "date");
        this.dataTypes.put((Type)((Object)String.class), "varchar");
        this.dataNames.put("boolean", Boolean.class);
        this.dataNames.put("tinyint", Byte.class);
        this.dataNames.put("bigint", Long.class);
        this.dataNames.put("int", Integer.class);
        this.dataNames.put("decimal", BigDecimal.class);
        this.dataNames.put("double", Double.class);
        this.dataNames.put("float", Float.class);
        this.dataNames.put("smallint", Short.class);
        this.dataNames.put("text", String.class);
        this.dataNames.put("varchar", String.class);
        this.dataNames.put("uuid", UUID.class);
        this.dataNames.put("blob", ByteBuffer.class);
        this.dataNames.put("varint", BigInteger.class);
        this.dataNames.put("time", LocalTime.class);
        this.dataNames.put("inet", InetAddress.class);
        this.dataNames.put("date", LocalDate.class);
    }

    public TableGenerator createTable(String keyspace, Class cls) {
        TableGenerator gen = null;
        try {
            gen = new TableGenerator(this, cls);
            gen.setKeyspace(keyspace);
        }
        catch (IntrospectionException e) {
            throw new SystemException((Throwable)e);
        }
        return gen;
    }

    public IndexGenerator createIndexes(String keyspace, Class cls) throws IntrospectionException {
        IndexGenerator gen = null;
        gen = new IndexGenerator(this, cls);
        gen.setKeyspace(keyspace);
        return gen;
    }

    public String getDataType(Type type) {
        return this.dataTypes.get(type);
    }

    public void setDataType(Type type, String dataType) {
        this.dataTypes.put(type, dataType);
        if (type instanceof Class) {
            this.dataNames.put(dataType, (Class)type);
        }
    }

    public Object getDataValue(String type, String value) {
        Class cls = this.dataNames.get(type);
        if (UUID.class.equals((Object)cls)) {
            return UUID.fromString(value);
        }
        if (byte[].class.isAssignableFrom(cls)) {
            throw new UnsupportedOperationException("byte[] is not supported");
        }
        try {
            return cls.getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public abstract String toCassandraName(String var1);

    public abstract Class<? extends Annotation> tableAnnotation();

    public abstract Annotation tableAnnotation(Class var1);

    public abstract String tableKeyspace(Class var1);

    public abstract String tableName(Class var1);

    public abstract boolean hasColumnAnnotation(AccessibleObject var1);

    public abstract boolean hasColumnAnnotation(PropertyDescriptor var1);

    public abstract String getColumnName(Field var1);

    public abstract String getColumnName(PropertyDescriptor var1);

    public abstract int partitionKeyIndex(AccessibleObject var1);

    public abstract int partitionKeyIndex(PropertyDescriptor var1);

    public abstract int clusteringColumnIndex(AccessibleObject var1);

    public abstract int clusteringColumnIndex(PropertyDescriptor var1);

    public abstract boolean isTransient(AccessibleObject var1);

    public abstract boolean isTransient(PropertyDescriptor var1);

    public abstract boolean isFrozen(AccessibleObject var1);

    public abstract boolean isFrozen(PropertyDescriptor var1);

    public abstract boolean isFrozenKey(AccessibleObject var1);

    public abstract boolean isFrozenKey(PropertyDescriptor var1);

    public abstract boolean isFrozenValue(AccessibleObject var1);

    public abstract boolean isFrozenValue(PropertyDescriptor var1);

    public boolean isTimeBased(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, TimeBased.class) != null;
    }

    public boolean isTimeBased(PropertyDescriptor descriptor) {
        return Accessor.getAnnotation((PropertyDescriptor)descriptor, TimeBased.class) != null;
    }
}

