/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.driver.cql.AsyncResultSet;
import net.e6tech.elements.cassandra.driver.cql.Row;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;

public class AsyncResultSetFutures<D>
extends AsyncFutures<AsyncResultSet, D> {
    static Logger logger = Logger.getLogger();

    AsyncResultSetFutures(Async async, List<Future<AsyncResultSet>> futures) {
        super(async, futures);
    }

    public Async<AsyncResultSet, D> inExecutionOrderRows(Consumer<Row> consumer) {
        this.futuresGet(this.futures, consumer);
        return this.async;
    }

    private void futuresGet(List<Future<AsyncResultSet>> list, Consumer<Row> consumer) {
        for (Future<AsyncResultSet> future : list) {
            try {
                if (this.getTimeout() > 0L) {
                    for (Row row : future.get(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                        consumer.accept(row);
                    }
                    continue;
                }
                for (Row row : future.get()) {
                    consumer.accept(row);
                }
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }
}

