/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.async.AsyncResultSetFutures;
import net.e6tech.elements.common.inject.Inject;

public class Async<T, D> {
    protected List<Future<T>> futures = new LinkedList<Future<T>>();
    Map<Future<T>, D> futuresData = new IdentityHashMap<Future<T>, D>(512);
    protected Session session;
    private AsyncFutures<T, D> result = this.createResult();

    public static void resetAll(Async ... asyncs) {
        if (asyncs != null) {
            for (Async async : asyncs) {
                async.reset();
            }
        }
    }

    protected AsyncFutures<T, D> createResult() {
        return new AsyncResultSetFutures(this, this.futures);
    }

    public Session getSession() {
        return this.session;
    }

    @Inject
    public void setSession(Session session) {
        this.session = session;
    }

    public Async<T, D> reset() {
        this.futures.clear();
        this.futuresData.clear();
        return this;
    }

    public AsyncFutures<T, D> getResult() {
        return this.result;
    }

    public AsyncFutures<T, D> acceptAll(AsyncFutures<T, D> result) {
        for (Future future : result.futures) {
            this.futures.add(future);
            if (!result.async.futuresData.containsKey(future)) continue;
            this.futuresData.put(future, result.async.futuresData.get(future));
        }
        return this.result;
    }

    public AsyncFutures<T, D> accept(D data, Future<T> future) {
        this.futures.add(future);
        if (data != null) {
            this.futuresData.put(future, data);
        }
        return this.result;
    }

    public AsyncFutures<T, D> accept(Collection<D> collection, Function<D, Future<T>> function) {
        this.resizeFuturesData(collection.size());
        for (D t : collection) {
            this.accept(t, function.apply(t));
        }
        return this.result;
    }

    protected void resizeFuturesData(int size) {
        int currentSize = this.futuresData.size();
        int totalSize = size + currentSize;
        IdentityHashMap<Future<T>, D> tmp = new IdentityHashMap<Future<T>, D>(Math.max((int)((float)totalSize / 0.75f) + 1, 16));
        tmp.putAll(this.futuresData);
        this.futuresData = tmp;
    }

    public Async<T, D> inExecutionOrder() {
        return this.inExecutionOrder((Consumer)null);
    }

    public Async<T, D> inExecutionOrder(Consumer<T> consumer) {
        return this.result.inExecutionOrder(consumer);
    }

    public Async<T, D> inExecutionOrder(BiConsumer<D, T> consumer) {
        return this.result.inExecutionOrder(consumer);
    }
}

