/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.Codec;
import net.e6tech.elements.cassandra.generator.ColumnGenerator;
import net.e6tech.elements.cassandra.generator.Generator;

public class CodecGenerator
extends AbstractGenerator {
    private List<ColumnGenerator> columnGenerators = new ArrayList<ColumnGenerator>();
    private String userType;

    CodecGenerator(Generator generator, String userType, Class<? extends Codec> codecClass) {
        super(generator);
        this.userType = userType;
        for (Codec.MappingDescriptor descriptor : Codec.analyze(codecClass)) {
            Type type = null;
            if (descriptor.getPropertyDescriptor().getReadMethod() != null) {
                type = descriptor.getPropertyDescriptor().getReadMethod().getGenericReturnType();
            } else if (descriptor.getPropertyDescriptor().getWriteMethod() != null) {
                type = descriptor.getPropertyDescriptor().getWriteMethod().getGenericParameterTypes()[0];
            }
            if (type == null) continue;
            this.columnGenerators.add(new ColumnGenerator(generator, type, descriptor));
        }
    }

    @Override
    public String getTableName() {
        return this.userType;
    }

    @Override
    public String getTableKeyspace() {
        return "";
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TYPE IF NOT EXISTS ");
        builder.append(this.fullyQualifiedTableName());
        builder.append(" (\n");
        boolean first = true;
        for (ColumnGenerator gen : this.columnGenerators) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n");
            }
            builder.append(gen.generate());
        }
        builder.append(")");
        return builder.toString();
    }
}

