/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.e6tech.elements.cassandra.annotations.Checkpoint;
import net.e6tech.elements.cassandra.annotations.PartitionUnit;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.reflection.Accessor;
import net.e6tech.elements.common.reflection.Accessors;
import net.e6tech.elements.common.util.SystemException;

public class Inspector {
    private Generator generator;
    private Class sourceClass;
    private boolean initialized = false;
    private TimeUnit timeUnit;
    private List<ColumnAccessor> partitionKeys = new LinkedList<ColumnAccessor>();
    private List<ColumnAccessor> clusteringKeys = new LinkedList<ColumnAccessor>();
    private List<ColumnAccessor> checkpoints = new LinkedList<ColumnAccessor>();
    private List<ColumnAccessor> primaryKeyColumns = new LinkedList<ColumnAccessor>();
    private Accessors<ColumnAccessor> accessors;
    private List<ColumnAccessor> columns;
    private Map<String, ColumnAccessor> columnMap;

    public Inspector(Class sourceClass, Generator generator) {
        this.sourceClass = sourceClass;
        this.generator = generator;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void addPartitionKey(ColumnAccessor descriptor) {
        this.partitionKeys.add(descriptor);
        Collections.sort(this.partitionKeys, Comparator.comparingInt(p -> p.position));
    }

    public void addClusteringKey(ColumnAccessor descriptor) {
        this.clusteringKeys.add(descriptor);
        Collections.sort(this.clusteringKeys, Comparator.comparingInt(p -> p.position));
    }

    public int getPartitionKeySize() {
        return this.partitionKeys.size();
    }

    public String getPartitionKeyColumn(int n) {
        if (this.partitionKeys.size() <= n) {
            return null;
        }
        return this.partitionKeys.get((int)n).columnName;
    }

    public Class getPartitionKeyClass(int n) {
        return this.getKeyClass(this.partitionKeys, n);
    }

    private Class getKeyClass(List<ColumnAccessor> keys, int n) {
        if (keys.size() <= n) {
            return null;
        }
        ColumnAccessor descriptor = keys.get(n);
        return descriptor.getType();
    }

    public Object getPartitionKey(Object object, int n) {
        return this.getKey(this.partitionKeys, object, n);
    }

    private Object getKey(List<ColumnAccessor> keys, Object object, int n) {
        if (keys.size() <= n) {
            return null;
        }
        return keys.get(n).get(object);
    }

    public String getCheckpointColumn(int n) {
        if (this.checkpoints.size() <= n) {
            return null;
        }
        return this.checkpoints.get((int)n).columnName;
    }

    public Comparable getCheckpoint(Object object, int n) {
        if (this.checkpoints.size() <= n) {
            return null;
        }
        return (Comparable)this.checkpoints.get(n).get(object);
    }

    public void setCheckpoint(Object object, int n, Comparable value) {
        if (this.checkpoints.size() <= n) {
            return;
        }
        this.checkpoints.get(n).set(object, value);
    }

    public int getCheckpointSize() {
        return this.checkpoints.size();
    }

    public String getClusteringKeyColumn(int n) {
        if (this.clusteringKeys.size() <= n) {
            return null;
        }
        return this.clusteringKeys.get((int)n).columnName;
    }

    public Class getClusteringKeyClass(int n) {
        return this.getKeyClass(this.clusteringKeys, n);
    }

    public Object getClusteringKey(Object object, int n) {
        return this.getKey(this.clusteringKeys, object, n);
    }

    public int getClusteringKeySize() {
        return this.clusteringKeys.size();
    }

    public String tableName() {
        return this.generator.tableName(this.sourceClass);
    }

    public void setPrimaryKey(PrimaryKey key, Object object) {
        try {
            int idx = 0;
            for (ColumnAccessor descriptor : this.partitionKeys) {
                if (key.length() <= idx) break;
                descriptor.set(object, key.get(idx));
                ++idx;
            }
            for (ColumnAccessor descriptor : this.clusteringKeys) {
                if (key.length() > idx) {
                    descriptor.set(object, key.get(idx));
                    ++idx;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public PrimaryKey getPrimaryKey(Object object) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (ColumnAccessor descriptor : this.partitionKeys) {
                list.add(descriptor.get(object));
            }
            for (ColumnAccessor descriptor : this.clusteringKeys) {
                list.add(descriptor.get(object));
            }
            return new PrimaryKey(list.toArray(new Object[0]));
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public List<ColumnAccessor> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<ColumnAccessor> getColumns() {
        return this.columns;
    }

    public ColumnAccessor getColumn(String column) {
        return this.columnMap.get(column);
    }

    private ColumnAccessor alloc(int position, Field field) {
        Generator gen = this.getGenerator();
        ColumnAccessor descriptor = new ColumnAccessor(position, gen.getColumnName(field), field.getName(), field);
        field.setAccessible(true);
        return descriptor;
    }

    private ColumnAccessor alloc(int position, Field field, List<ColumnAccessor> list, Map<String, ColumnAccessor> map) {
        ColumnAccessor descriptor = this.alloc(position, field);
        map.put(field.getName(), descriptor);
        map.put(descriptor.columnName, descriptor);
        list.add(descriptor);
        return descriptor;
    }

    private ColumnAccessor alloc(int position, PropertyDescriptor desc) {
        Generator gen = this.getGenerator();
        ColumnAccessor descriptor = new ColumnAccessor(position, gen.getColumnName(desc), desc.getName(), desc);
        return descriptor;
    }

    private ColumnAccessor alloc(int position, PropertyDescriptor desc, List<ColumnAccessor> list, Map<String, ColumnAccessor> map) {
        ColumnAccessor descriptor = this.alloc(position, desc);
        map.put(desc.getName(), descriptor);
        map.put(descriptor.columnName, descriptor);
        list.add(descriptor);
        return descriptor;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap propertyMap = new HashMap(100);
        HashMap chkMap = new HashMap(100);
        Generator gen = this.getGenerator();
        Class cls = this.getSourceClass();
        AtomicInteger position = new AtomicInteger(0);
        HashSet transientNames = new HashSet(50);
        this.accessors = new Accessors(cls, field -> {
            Checkpoint chk;
            int cc;
            if (Modifier.isStrict(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                return null;
            }
            if (gen.isTransient((AccessibleObject)field)) {
                transientNames.add(field.getName());
                return null;
            }
            if (propertyMap.get(field.getName()) != null) {
                return null;
            }
            int pk = gen.partitionKeyIndex((AccessibleObject)field);
            if (pk >= 0) {
                this.alloc(pk, (Field)field, this.partitionKeys, (Map<String, ColumnAccessor>)propertyMap);
                PartitionUnit unit = field.getAnnotation(PartitionUnit.class);
                if (unit != null && pk == 0) {
                    this.timeUnit = unit.value();
                }
            }
            if ((cc = gen.clusteringColumnIndex((AccessibleObject)field)) >= 0) {
                this.alloc(cc, (Field)field, this.clusteringKeys, (Map<String, ColumnAccessor>)propertyMap);
            }
            if ((chk = field.getAnnotation(Checkpoint.class)) != null) {
                this.alloc(chk.value(), (Field)field, this.checkpoints, (Map<String, ColumnAccessor>)chkMap);
            }
            return this.alloc(position.getAndIncrement(), (Field)field);
        }, (desc, existing) -> {
            int cc;
            int pk;
            if (gen.isTransient((PropertyDescriptor)desc)) {
                transientNames.add(desc.getName());
                return null;
            }
            if (transientNames.contains(desc.getName())) {
                return null;
            }
            if (desc.getName().equals("class")) {
                return null;
            }
            ColumnAccessor descriptor = (ColumnAccessor)((Object)((Object)propertyMap.get(desc.getName())));
            String columnName = gen.getColumnName((PropertyDescriptor)desc);
            if (descriptor == null) {
                descriptor = (ColumnAccessor)((Object)((Object)propertyMap.get(columnName)));
            }
            if ((pk = gen.partitionKeyIndex((PropertyDescriptor)desc)) >= 0 && descriptor == null) {
                descriptor = this.alloc(pk, (PropertyDescriptor)desc, this.partitionKeys, (Map<String, ColumnAccessor>)propertyMap);
                PartitionUnit unit = (PartitionUnit)Accessor.getAnnotation((PropertyDescriptor)desc, PartitionUnit.class);
                if (unit != null && pk == 0) {
                    this.timeUnit = unit.value();
                }
            }
            if ((cc = gen.clusteringColumnIndex((PropertyDescriptor)desc)) >= 0 && descriptor == null) {
                this.alloc(cc, (PropertyDescriptor)desc, this.clusteringKeys, (Map<String, ColumnAccessor>)propertyMap);
            }
            Checkpoint chk = (Checkpoint)Accessor.getAnnotation((PropertyDescriptor)desc, Checkpoint.class);
            ColumnAccessor chkDescriptor = (ColumnAccessor)((Object)((Object)chkMap.get(desc.getName())));
            if (chkDescriptor == null) {
                chkDescriptor = (ColumnAccessor)((Object)((Object)chkMap.get(columnName)));
            }
            if (chk != null && chkDescriptor == null) {
                this.alloc(chk.value(), (PropertyDescriptor)desc, this.checkpoints, (Map<String, ColumnAccessor>)chkMap);
            }
            return existing != null ? (ColumnAccessor)existing.descriptor(desc) : this.alloc(position.getAndIncrement(), (PropertyDescriptor)desc);
        });
        Collections.sort(this.partitionKeys, Comparator.comparingInt(p -> p.position));
        Collections.sort(this.clusteringKeys, Comparator.comparingInt(p -> p.position));
        Collections.sort(this.checkpoints, Comparator.comparingInt(p -> p.position));
        this.columns = new ArrayList(this.accessors.getAccessors().values());
        Collections.sort(this.columns, Comparator.comparingInt(p -> p.position));
        for (ColumnAccessor a : this.partitionKeys) {
            this.primaryKeyColumns.add(a);
        }
        for (ColumnAccessor a : this.clusteringKeys) {
            this.primaryKeyColumns.add(a);
        }
        this.columnMap = new HashMap<String, ColumnAccessor>(this.columns.size(), 1.0f);
        for (ColumnAccessor a : this.columns) {
            this.columnMap.put(a.getColumnName(), a);
        }
    }

    public static class ColumnAccessor
    extends Accessor {
        int position;
        String columnName;
        String property;

        public ColumnAccessor(int pos, String columnName, String property, Field field) {
            super(field);
            this.position = pos;
            this.columnName = columnName;
            this.property = property;
        }

        public ColumnAccessor(int pos, String columnName, String property, PropertyDescriptor desc) {
            super(desc);
            this.position = pos;
            this.columnName = columnName;
            this.property = property;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

