/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v4;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.driver.Wrapper;
import net.e6tech.elements.cassandra.driver.v4.GeneratorV4;
import net.e6tech.elements.cassandra.driver.v4.MappingManager;
import net.e6tech.elements.cassandra.driver.v4.SessionV4;
import net.e6tech.elements.cassandra.driver.v4.SibylV4;
import net.e6tech.elements.cassandra.driver.v4.TableMetadataV4;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.TextBuilder;

public class SessionProviderV4
extends SessionProvider {
    private Generator generator = new GeneratorV4();
    private CqlSession session;
    private Map<String, ?> driverOptions = new LinkedHashMap();
    private MappingManager mappingManager;
    private boolean v3Annotation = false;
    private String namingConvention;

    public boolean isV3Annotation() {
        return this.v3Annotation;
    }

    public void setV3Annotation(boolean v3Annotation) {
        this.v3Annotation = v3Annotation;
    }

    public String getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(String namingConvention) {
        this.namingConvention = namingConvention;
    }

    public Map<String, ?> getDriverOptions() {
        return this.driverOptions;
    }

    public void setDriverOptions(Map<String, ?> driverOptions) {
        this.driverOptions = driverOptions;
    }

    @Override
    public net.e6tech.elements.cassandra.driver.metadata.TableMetadata getTableMetadata(String keyspaceIn, String tableName) {
        KeyspaceMetadata keyspaceMetadata = this.session.getMetadata().getKeyspace(this.getKeyspace(keyspaceIn)).orElse(null);
        if (keyspaceMetadata == null) {
            return null;
        }
        TableMetadata tableMetadata = keyspaceMetadata.getTable(tableName).orElse(null);
        return tableMetadata == null ? null : new TableMetadataV4(this.generator, tableMetadata);
    }

    @Override
    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    protected Session createSession(String keyspaceIn) {
        return Wrapper.wrap(new SessionV4(), this.session);
    }

    @Override
    protected void initGenerator() {
        if (this.isV3Annotation()) {
            try {
                this.generator = (Generator)this.getClass().getClassLoader().loadClass("net.e6tech.elements.cassandra.driver.v3.GeneratorV3").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        } else {
            GeneratorV4 gen = new GeneratorV4();
            if (this.getNamingConvention() != null) {
                gen.setNamingConvention(NamingConvention.valueOf((String)this.getNamingConvention()));
            }
            this.generator = gen;
        }
    }

    @Override
    protected void initDriver() {
        if (this.session != null) {
            return;
        }
        ProgrammaticDriverConfigLoaderBuilder configBuilder = DriverConfigLoader.programmaticBuilder();
        for (Map.Entry<String, ?> entry : this.driverOptions.entrySet()) {
            configBuilder.withString((DriverOption)DefaultDriverOption.valueOf((String)entry.getKey()), "" + entry.getValue());
        }
        DriverConfigLoader loader = configBuilder.build();
        CqlSessionBuilder builder = (CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(loader)).addContactPoint(new InetSocketAddress(this.getHost(), this.getPort()));
        try {
            this.session = (CqlSession)((CqlSessionBuilder)builder.withKeyspace(this.getKeyspace())).build();
        }
        catch (InvalidKeyspaceException ex) {
            this.session = (CqlSession)((CqlSessionBuilder)builder.withKeyspace((String)null)).build();
            this.createKeyspaceArguments.put("keyspace", this.getKeyspace());
            this.session.execute(TextBuilder.using((String)this.createKeyspace).build(this.createKeyspaceArguments));
            this.session.close();
            this.session = (CqlSession)((CqlSessionBuilder)builder.withKeyspace(this.getKeyspace())).build();
        }
        this.mappingManager = new MappingManager(this, this.session, this.getKeyspace());
    }

    @Override
    protected void initKeyspace() {
    }

    @Override
    protected void postInit() {
    }

    @Override
    public void onOpen(Resources resources) {
        resources.rebind(Session.class, (Object)Wrapper.wrap(new SessionV4(), this.session));
        resources.rebind(MappingManager.class, (Object)this.mappingManager);
        resources.rebind(SessionProvider.class, (Object)this);
        Sibyl s = (Sibyl)resources.newInstance(SibylV4.class);
        s.setReadOptions(this.getDefaultReadOptions());
        s.setWriteOptions(this.getDefaultWriteOptions());
        resources.rebind(Sibyl.class, (Object)s);
    }

    @Override
    public void onClosed(Resources resources) {
    }

    @Override
    public void onShutdown() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

