/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v3;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.driver.Wrapper;
import net.e6tech.elements.cassandra.driver.cql.AsyncResultSet;
import net.e6tech.elements.cassandra.driver.cql.Bound;
import net.e6tech.elements.cassandra.driver.cql.Prepared;
import net.e6tech.elements.cassandra.driver.cql.ResultSet;
import net.e6tech.elements.cassandra.driver.v3.AsyncResultSetV3;
import net.e6tech.elements.cassandra.driver.v3.BoundV3;
import net.e6tech.elements.cassandra.driver.v3.PreparedV3;
import net.e6tech.elements.cassandra.driver.v3.ResultSetV3;
import net.e6tech.elements.common.util.StringUtil;

public class SessionV3
extends Wrapper<com.datastax.driver.core.Session>
implements Session {
    @Override
    public ResultSet execute(String query) {
        return Wrapper.wrap(new ResultSetV3(), ((com.datastax.driver.core.Session)this.unwrap()).execute(query));
    }

    @Override
    public ResultSet execute(String keyspace, String query) {
        if (StringUtil.isNullOrEmpty((String)keyspace)) {
            return this.execute(query);
        }
        SimpleStatement stmt = new SimpleStatement(query);
        stmt.setKeyspace(keyspace);
        return Wrapper.wrap(new ResultSetV3(), ((com.datastax.driver.core.Session)this.unwrap()).execute((Statement)stmt));
    }

    @Override
    public ResultSet execute(Bound bound) {
        return Wrapper.wrap(new ResultSetV3(), ((com.datastax.driver.core.Session)this.unwrap()).execute((Statement)((BoundV3)bound).unwrap()));
    }

    @Override
    public Future<AsyncResultSet> executeAsync(String keyspace, String query) {
        if (StringUtil.isNullOrEmpty((String)keyspace)) {
            return this.executeAsync(query);
        }
        SimpleStatement stmt = new SimpleStatement(query);
        stmt.setKeyspace(keyspace);
        return new FutureAsyncResultSet(((com.datastax.driver.core.Session)this.unwrap()).executeAsync((Statement)stmt));
    }

    @Override
    public Future<AsyncResultSet> executeAsync(String query) {
        ResultSetFuture future = ((com.datastax.driver.core.Session)this.unwrap()).executeAsync(query);
        return new FutureAsyncResultSet(future);
    }

    @Override
    public Future<AsyncResultSet> executeAsync(Bound bound) {
        ResultSetFuture future = ((com.datastax.driver.core.Session)this.unwrap()).executeAsync((Statement)((BoundV3)bound).unwrap());
        return new FutureAsyncResultSet(future);
    }

    @Override
    public Prepared prepare(String query) {
        return Wrapper.wrap(new PreparedV3(), ((com.datastax.driver.core.Session)this.unwrap()).prepare(query));
    }

    private static class FutureAsyncResultSet
    implements Future<AsyncResultSet> {
        private ResultSetFuture future;

        FutureAsyncResultSet(ResultSetFuture future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public AsyncResultSet get() throws InterruptedException, ExecutionException {
            com.datastax.driver.core.ResultSet rs = (com.datastax.driver.core.ResultSet)this.future.get();
            return Wrapper.wrap(new AsyncResultSetV3(), rs);
        }

        @Override
        public AsyncResultSet get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            com.datastax.driver.core.ResultSet rs = (com.datastax.driver.core.ResultSet)this.future.get(timeout, unit);
            return Wrapper.wrap(new AsyncResultSetV3(), rs);
        }
    }
}

