/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v3;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.e6tech.elements.cassandra.driver.datatype.ListType;
import net.e6tech.elements.cassandra.driver.datatype.MapType;
import net.e6tech.elements.cassandra.driver.datatype.SetType;
import net.e6tech.elements.cassandra.driver.metadata.AbstractColumnMetadata;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.TypeDescriptorImpl;

public class ColumnMetadataV3
extends AbstractColumnMetadata {
    public ColumnMetadataV3(Generator generator, ColumnMetadata metadata) {
        this.setName(metadata.getName());
        DataType dataType = metadata.getType();
        net.e6tech.elements.cassandra.driver.datatype.DataType d = ColumnMetadataV3.createDataType(generator, dataType);
        this.setDataType(d);
    }

    protected static net.e6tech.elements.cassandra.driver.datatype.DataType createDataType(Generator generator, DataType dataType) {
        TypeDescriptorImpl impl = new TypeDescriptorImpl();
        Class type = null;
        switch (dataType.getName()) {
            case ASCII: {
                type = String.class;
                break;
            }
            case BIGINT: {
                type = Long.class;
                break;
            }
            case BLOB: {
                type = byte[].class;
                break;
            }
            case BOOLEAN: {
                type = Boolean.class;
                break;
            }
            case COUNTER: {
                type = Long.class;
                break;
            }
            case DECIMAL: {
                type = BigDecimal.class;
                break;
            }
            case DOUBLE: {
                type = Double.class;
                break;
            }
            case FLOAT: {
                type = Float.class;
                break;
            }
            case INT: {
                type = Integer.class;
                break;
            }
            case TEXT: {
                type = String.class;
                break;
            }
            case TIMESTAMP: {
                type = Instant.class;
                break;
            }
            case UUID: {
                type = UUID.class;
                break;
            }
            case VARCHAR: {
                type = String.class;
                break;
            }
            case VARINT: {
                type = BigInteger.class;
                break;
            }
            case TIMEUUID: {
                type = UUID.class;
                impl.setTimeBased(true);
                break;
            }
            case INET: {
                type = InetAddress.class;
                break;
            }
            case DATE: {
                type = LocalDate.class;
                break;
            }
            case TIME: {
                type = LocalTime.class;
                break;
            }
            case SMALLINT: {
                type = Short.class;
                break;
            }
            case TINYINT: {
                type = Byte.class;
                break;
            }
            case LIST: {
                type = List.class;
                break;
            }
            case MAP: {
                type = Map.class;
                break;
            }
            case SET: {
                type = Set.class;
            }
        }
        if (type == null) {
            return null;
        }
        impl.setFrozen(dataType.isFrozen());
        net.e6tech.elements.cassandra.driver.datatype.DataType d = net.e6tech.elements.cassandra.driver.datatype.DataType.create(generator, type, impl);
        if (d instanceof ListType && dataType.getTypeArguments().size() > 0) {
            ((ListType)d).setComponentType(ColumnMetadataV3.createDataType(generator, (DataType)dataType.getTypeArguments().get(0)));
        } else if (d instanceof SetType && dataType.getTypeArguments().size() > 0) {
            ((SetType)d).setComponentType(ColumnMetadataV3.createDataType(generator, (DataType)dataType.getTypeArguments().get(0)));
        } else if (d instanceof MapType && dataType.getTypeArguments().size() > 1) {
            net.e6tech.elements.cassandra.driver.datatype.DataType keyType = ColumnMetadataV3.createDataType(generator, (DataType)dataType.getTypeArguments().get(0));
            net.e6tech.elements.cassandra.driver.datatype.DataType valueType = ColumnMetadataV3.createDataType(generator, (DataType)dataType.getTypeArguments().get(1));
            ((MapType)d).setKeyType(keyType);
            ((MapType)d).setValueType(valueType);
        }
        return d;
    }
}

