/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.e6tech.elements.cassandra.Consistency;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.async.AsyncPrepared;
import net.e6tech.elements.cassandra.driver.cql.BaseResultSet;
import net.e6tech.elements.cassandra.driver.cql.Bound;
import net.e6tech.elements.cassandra.driver.cql.Prepared;
import net.e6tech.elements.cassandra.driver.cql.ResultSet;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;

public abstract class Sibyl {
    private static Cache<String, Prepared> preparedStatementCache = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(200).maximumSize(500L).build();
    private Resources resources;
    private ReadOptions readOptions = new ReadOptions().consistency(Consistency.LOCAL_SERIAL);
    private WriteOptions writeOptions = new WriteOptions().consistency(Consistency.LOCAL_QUORUM).saveNullFields(false);

    public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return (T)this.resources.configurator().computeIfAbsent(key, mappingFunction);
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    public void setReadOptions(ReadOptions readOptions) {
        this.readOptions = readOptions;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public void setWriteOptions(WriteOptions writeOptions) {
        this.writeOptions = writeOptions;
    }

    public Resources getResources() {
        return this.resources;
    }

    @Inject
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Generator getGenerator() {
        return (Generator)this.getResources().getInstance(Generator.class);
    }

    public Session getSession() {
        return (Session)this.resources.getInstance(Session.class);
    }

    public <T, D> Async<T, D> createAsync() {
        return (Async)this.getResources().newInstance(Async.class);
    }

    public <D> AsyncPrepared<D> createAsync(String query) {
        Prepared pstmt;
        try {
            pstmt = (Prepared)preparedStatementCache.get((Object)query, () -> this.getSession().prepare(query));
        }
        catch (ExecutionException e) {
            pstmt = this.getSession().prepare(query);
        }
        return ((AsyncPrepared)this.getResources().newInstance(AsyncPrepared.class)).prepare(pstmt);
    }

    public <D> AsyncPrepared<D> createAsync(Prepared stmt) {
        return ((AsyncPrepared)this.getResources().newInstance(AsyncPrepared.class)).prepare(stmt);
    }

    public ResultSet execute(String query, Map<String, Object> map) {
        Prepared pstmt;
        try {
            pstmt = (Prepared)preparedStatementCache.get((Object)query, () -> this.getSession().prepare(query));
        }
        catch (ExecutionException e) {
            pstmt = this.getSession().prepare(query);
        }
        return this.execute(pstmt, map);
    }

    protected ResultSet execute(Prepared pstmt, Map<String, Object> map) {
        Bound bound = pstmt.bind();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                bound.setToNull(entry.getKey());
                continue;
            }
            if (entry.getValue() instanceof List) {
                bound.setList(entry.getKey(), (List)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Set) {
                bound.setSet(entry.getKey(), (Set)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                bound.setMap(entry.getKey(), (Map)entry.getValue());
                continue;
            }
            bound.set(entry.getKey(), entry.getValue(), entry.getValue().getClass());
        }
        return this.getSession().execute(bound);
    }

    public abstract <T> T get(Class<T> var1, PrimaryKey var2);

    public abstract <T> T get(Class<T> var1, PrimaryKey var2, ReadOptions var3);

    public abstract <X> AsyncFutures<X, PrimaryKey> get(Collection<PrimaryKey> var1, Class<X> var2, ReadOptions var3);

    public abstract <T> void save(Class<T> var1, T var2);

    public abstract <T> void save(Class<T> var1, T var2, WriteOptions var3);

    public abstract <T> void delete(Class<T> var1, T var2);

    public abstract <X> void save(Collection<X> var1, Class<X> var2);

    public abstract <X> void save(Collection<X> var1, Class<X> var2, WriteOptions var3);

    public abstract <X> X one(Class<X> var1, String var2, Map<String, Object> var3);

    public abstract <X> List<X> all(Class<X> var1, String var2, Map<String, Object> var3);

    public abstract <X> List<X> mapAll(Class<X> var1, BaseResultSet var2);

    public Inspector getInspector(Class cls) {
        return ((SessionProvider)this.getResources().getInstance(SessionProvider.class)).getInspector(cls);
    }
}

