/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.e6tech.elements.cassandra.Consistency;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.driver.metadata.TableMetadata;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.BindClass;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.MapBuilder;
import net.e6tech.elements.common.util.SystemException;

@BindClass(value=SessionProvider.class)
public abstract class SessionProvider
implements ResourceProvider,
Initializable {
    private static final String CREATE_KEYSPACE = "CREATE KEYSPACE IF NOT EXISTS ${keyspace}  WITH replication = {'class':'SimpleStrategy', 'replication_factor' : ${replication}};";
    private static final Map<String, Object> CREATE_KEYSPACE_ARGUMENTS = Collections.unmodifiableMap(MapBuilder.of((Object)"replication", (Object)3));
    private Cache<Class, Inspector> inspectors = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(2000L).build();
    protected String createKeyspace = "CREATE KEYSPACE IF NOT EXISTS ${keyspace}  WITH replication = {'class':'SimpleStrategy', 'replication_factor' : ${replication}};";
    protected Map<String, Object> createKeyspaceArguments = new HashMap<String, Object>(CREATE_KEYSPACE_ARGUMENTS);
    private String host;
    private int port = 9042;
    private String keyspace;
    private Provision provision;
    private int maxSessions = 20;
    private int coreConnections = 20;
    private int maxConnections = 200;
    private int heartbeatIntervalSeconds = 10000;
    private int maxRequests = 32768;
    private int poolTimeout = 5000;
    private int readTimeout = 20000;
    private Boolean keepAlive;
    private Class<? extends LastUpdate> lastUpdateClass = LastUpdate.class;
    private Map<String, Session> sessions = new HashMap<String, Session>();
    private WriteOptions defaultWriteOptions = new WriteOptions().consistency(Consistency.LOCAL_QUORUM).saveNullFields(false);
    private ReadOptions defaultReadOptions = new ReadOptions().consistency(Consistency.LOCAL_SERIAL);
    private boolean sharedSession = false;

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public String getCreateKeyspace() {
        return this.createKeyspace;
    }

    public void setCreateKeyspace(String createKeyspace) {
        this.createKeyspace = createKeyspace;
    }

    public Map<String, Object> getCreateKeyspaceArguments() {
        return this.createKeyspaceArguments;
    }

    public void setCreateKeyspaceArguments(Map<String, Object> createKeyspaceArguments) {
        this.createKeyspaceArguments = createKeyspaceArguments;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public int getCoreConnections() {
        return this.coreConnections;
    }

    public void setCoreConnections(int coreConnections) {
        this.coreConnections = coreConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public int getPoolTimeout() {
        return this.poolTimeout;
    }

    public void setPoolTimeout(int poolTimeout) {
        this.poolTimeout = poolTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public abstract TableMetadata getTableMetadata(String var1, String var2);

    protected String getKeyspace(String keyspaceIn) {
        String ks = keyspaceIn;
        if (ks == null) {
            ks = this.keyspace;
        }
        return ks;
    }

    public Cache<Class, Inspector> getInspectors() {
        return this.inspectors;
    }

    public void setInspectors(Cache<Class, Inspector> inspectors) {
        this.inspectors = inspectors;
    }

    public Map<String, Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Map<String, Session> sessions) {
        this.sessions = sessions;
    }

    public WriteOptions getDefaultWriteOptions() {
        return this.defaultWriteOptions;
    }

    public void setDefaultWriteOptions(WriteOptions defaultWriteOptions) {
        this.defaultWriteOptions = defaultWriteOptions;
    }

    public ReadOptions getDefaultReadOptions() {
        return this.defaultReadOptions;
    }

    public void setDefaultReadOptions(ReadOptions defaultReadOptions) {
        this.defaultReadOptions = defaultReadOptions;
    }

    public boolean isSharedSession() {
        return this.sharedSession;
    }

    public void setSharedSession(boolean sharedSession) {
        this.sharedSession = sharedSession;
    }

    public Class<? extends LastUpdate> getLastUpdateClass() {
        return this.lastUpdateClass;
    }

    public void setLastUpdateClass(Class<? extends LastUpdate> lastUpdateClass) {
        this.lastUpdateClass = lastUpdateClass;
    }

    public abstract Generator getGenerator();

    public synchronized Session buildSession(String keyspaceIn) {
        return this.sessions.computeIfAbsent(keyspaceIn, k -> this.createSession(this.getKeyspace(keyspaceIn)));
    }

    protected abstract Session createSession(String var1);

    protected abstract void initGenerator();

    protected abstract void initDriver();

    protected abstract void initKeyspace();

    protected abstract void postInit();

    public void initialize(Resources resources) {
        this.initGenerator();
        this.getProvision().getResourceManager().bind(Generator.class, (Object)this.getGenerator());
        this.initDriver();
        this.initKeyspace();
        this.getProvision().getResourceManager().rebind(SessionProvider.class, (Object)this);
        this.postInit();
    }

    public Inspector getInspector(Class cls) {
        Callable<Inspector> loader = () -> {
            Inspector inspector = new Inspector(cls, this.getGenerator());
            inspector.initialize();
            return inspector;
        };
        try {
            return (Inspector)this.inspectors.get((Object)cls, loader);
        }
        catch (ExecutionException e) {
            try {
                return loader.call();
            }
            catch (Exception e1) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    public abstract void onOpen(Resources var1);

    public void afterOpen(Resources resources) {
    }

    public void onCommit(Resources resources) {
    }

    public void afterCommit(Resources resources) {
    }

    public void afterAbort(Resources resources) {
    }

    public void onAbort(Resources resources) {
    }

    public abstract void onClosed(Resources var1);

    public abstract void onShutdown();
}

