/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.e6tech.elements.cassandra.annotations.Mapping;
import net.e6tech.elements.cassandra.annotations.Mappings;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.TextSubstitution;

public abstract class Codec<T>
extends TypeCodec<T> {
    private final TypeCodec<UDTValue> innerCodec;
    private List<MappingDescriptor> mappingDescriptors;

    public Codec(TypeCodec<UDTValue> innerCodec, Class<T> javaType) {
        super(innerCodec.getCqlType(), javaType);
        this.innerCodec = innerCodec;
        this.mappingDescriptors = Codec.analyze(((Object)((Object)this)).getClass());
    }

    public List<MappingDescriptor> getMappingDescriptors() {
        return this.mappingDescriptors;
    }

    protected TypeCodec<UDTValue> getInnerCodec() {
        return this.innerCodec;
    }

    protected UserType getUserType() {
        return (UserType)this.innerCodec.getCqlType();
    }

    public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        UDTValue udtValue = this.getUserType().newValue();
        this.serialize(udtValue, value);
        return this.getInnerCodec().serialize((Object)udtValue, protocolVersion);
    }

    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        return this.deserialize((UDTValue)this.getInnerCodec().deserialize(bytes, protocolVersion));
    }

    public T parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        return this.deserialize((UDTValue)this.getInnerCodec().parse(value));
    }

    public String format(T value) {
        if (value == null) {
            return null;
        }
        UDTValue udtValue = this.getUserType().newValue();
        this.serialize(udtValue, value);
        return this.getInnerCodec().format((Object)udtValue);
    }

    public T deserialize(UDTValue udtValue) {
        Object t = null;
        try {
            t = this.getJavaType().getRawType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        for (MappingDescriptor descriptor : this.mappingDescriptors) {
            if (descriptor.deserialize == null) continue;
            descriptor.deserialize.accept(udtValue, t);
        }
        return (T)t;
    }

    public void serialize(UDTValue udtValue, T value) {
        for (MappingDescriptor descriptor : this.mappingDescriptors) {
            if (descriptor.serialize == null) continue;
            descriptor.serialize.accept(udtValue, value);
        }
    }

    public static List<MappingDescriptor> analyze(Class<? extends Codec> codecClass) {
        Class mappedClass = Reflection.getParametrizedType(codecClass, (int)0);
        ArrayList<MappingDescriptor> descriptors = new ArrayList<MappingDescriptor>();
        Mappings mappings = codecClass.getAnnotation(Mappings.class);
        if (mappings == null) {
            return descriptors;
        }
        String[] implicit = mappings.value();
        StringBuilder builder = new StringBuilder();
        for (String columnName : implicit) {
            builder.setLength(0);
            String[] parts = columnName.split("_");
            boolean first = true;
            for (String s : parts) {
                if (first) {
                    builder.append(s);
                    first = false;
                    continue;
                }
                builder.append(TextSubstitution.capitalize((String)s));
            }
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(builder.toString(), mappedClass);
                descriptors.add(new MappingDescriptor(null, columnName, descriptor));
            }
            catch (IntrospectionException e) {
                throw new SystemException((Throwable)e);
            }
        }
        for (Mapping mapping : mappings.mappings()) {
            mapping.property();
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(mapping.property(), mappedClass);
                descriptors.add(new MappingDescriptor(mapping, mapping.value(), descriptor));
            }
            catch (IntrospectionException e) {
                throw new SystemException((Throwable)e);
            }
        }
        return descriptors;
    }

    public static class MappingDescriptor
    implements TypeDescriptor {
        private String columnName;
        private PropertyDescriptor descriptor;
        private BiConsumer<UDTValue, Object> deserialize;
        private BiConsumer<UDTValue, Object> serialize;
        private ParameterizedType parameterizedType;
        private Mapping mapping;

        MappingDescriptor(Mapping mapping, String columnName, PropertyDescriptor descriptor) {
            Class<?> pType;
            this.mapping = mapping;
            this.columnName = columnName;
            this.descriptor = descriptor;
            if (descriptor.getReadMethod() != null) {
                pType = descriptor.getReadMethod().getReturnType();
                Type genericType = descriptor.getReadMethod().getGenericReturnType();
                if (genericType instanceof ParameterizedType) {
                    this.parameterizedType = (ParameterizedType)genericType;
                }
                if (List.class.isAssignableFrom(pType)) {
                    this.deserialize = (udt, o) -> this.set(o, udt.getList(this.columnName, (Class)this.parameterizedType.getActualTypeArguments()[0]));
                } else if (Set.class.isAssignableFrom(pType)) {
                    this.serialize = (udt, o) -> {
                        UDTValue cfr_ignored_0 = (UDTValue)udt.setSet(this.columnName, (Set)this.get(o));
                    };
                } else {
                    this.deserialize = Map.class.isAssignableFrom(pType) ? (udt, o) -> this.set(o, udt.getMap(this.columnName, (Class)this.parameterizedType.getActualTypeArguments()[0], (Class)this.parameterizedType.getActualTypeArguments()[1])) : (Enum.class.isAssignableFrom(pType) ? (udt, o) -> {
                        String str = udt.getString(this.columnName);
                        if (str != null) {
                            Object e = Enum.valueOf(descriptor.getPropertyType(), str);
                            this.set(o, e);
                        } else {
                            this.set(o, null);
                        }
                    } : (byte[].class.isAssignableFrom(pType) ? (udt, o) -> {
                        ByteBuffer byteBuffer = udt.getBytes(this.columnName);
                        if (byteBuffer != null) {
                            byte[] bytes = byteBuffer.array();
                            this.set(o, bytes);
                        } else {
                            this.set(o, null);
                        }
                    } : (udt, o) -> this.set(o, udt.get(this.columnName, descriptor.getPropertyType()))));
                }
            }
            if (descriptor.getWriteMethod() != null) {
                pType = descriptor.getWriteMethod().getParameterTypes()[0];
                this.serialize = List.class.isAssignableFrom(pType) ? (udt, o) -> {
                    UDTValue cfr_ignored_0 = (UDTValue)udt.setList(this.columnName, (List)this.get(o));
                } : (Set.class.isAssignableFrom(pType) ? (udt, o) -> {
                    UDTValue cfr_ignored_0 = (UDTValue)udt.setSet(this.columnName, (Set)this.get(o));
                } : (Map.class.isAssignableFrom(pType) ? (udt, o) -> {
                    UDTValue cfr_ignored_0 = (UDTValue)udt.setMap(this.columnName, (Map)this.get(o));
                } : (Enum.class.isAssignableFrom(pType) ? (udt, o) -> {
                    Enum e = (Enum)this.get(o);
                    String str = e == null ? null : e.toString();
                    udt.setString(this.columnName, str);
                } : (byte[].class.isAssignableFrom(pType) ? (udt, o) -> {
                    byte[] bytes = (byte[])this.get(o);
                    if (bytes != null) {
                        udt.setBytes(this.columnName, ByteBuffer.wrap(bytes));
                    } else {
                        udt.setToNull(this.columnName);
                    }
                } : (udt, o) -> {
                    UDTValue cfr_ignored_0 = (UDTValue)udt.set(this.columnName, this.get(o), descriptor.getPropertyType());
                }))));
            }
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.descriptor;
        }

        <U> U get(Object target) {
            try {
                return (U)this.descriptor.getReadMethod().invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }

        void set(Object target, Object value) {
            try {
                this.descriptor.getWriteMethod().invoke(target, value);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }

        @Override
        public boolean isFrozen() {
            return this.mapping != null && this.mapping.frozen();
        }

        @Override
        public boolean isFrozenKey() {
            return this.mapping != null && this.mapping.frozenKey();
        }

        @Override
        public boolean isFrozenValue() {
            return this.mapping != null && this.mapping.frozenValue();
        }

        @Override
        public boolean isTimeBased() {
            return this.mapping != null && this.mapping.timeBased();
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }
    }
}

