/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v3;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.ReadOptions;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.WriteOptions;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.driver.cql.BaseResultSet;
import net.e6tech.elements.cassandra.driver.cql.ResultSet;
import net.e6tech.elements.cassandra.driver.v3.ResultSetV3;
import net.e6tech.elements.cassandra.etl.PrimaryKey;

public class SibylV3
extends Sibyl {
    @Override
    public <X> X one(Class<X> cls, String query, Map<String, Object> map) {
        ResultSet resultSet = this.execute(query, map);
        Result result = this.getMapper(cls).map((com.datastax.driver.core.ResultSet)((ResultSetV3)resultSet).unwrap());
        return (X)result.one();
    }

    @Override
    public <X> List<X> all(Class<X> cls, String query, Map<String, Object> map) {
        ResultSet resultSet = this.execute(query, map);
        Result result = this.getMapper(cls).map((com.datastax.driver.core.ResultSet)((ResultSetV3)resultSet).unwrap());
        return result.all();
    }

    public MappingManager getMappingManager() {
        return (MappingManager)this.getResources().getInstance(MappingManager.class);
    }

    @Override
    public <T> void save(Class<T> cls, T entity) {
        this.getMapper(cls).save(entity);
    }

    @Override
    public <T> void save(Class<T> cls, T entity, WriteOptions options) {
        this.getMapper(cls).save(entity, this.writeOptions(options));
    }

    @Override
    public <X> void save(Collection<X> list, Class<X> cls) {
        this.save(list, cls, null);
    }

    @Override
    public <X> void save(Collection<X> list, Class<X> cls, WriteOptions userOptions) {
        Async async = this.createAsync();
        Mapper mapper = this.getMapper(cls);
        AsyncFutures futures = async.accept(list, item -> mapper.saveAsync(item, this.writeOptions(userOptions)));
        if (userOptions != null && userOptions.timeout != null && userOptions.timeout > 0L) {
            futures.timeout(userOptions.timeout);
        }
        futures.inExecutionOrder();
    }

    private Mapper.Option[] writeOptions(WriteOptions userOptions) {
        WriteOptions options = WriteOptions.from(userOptions);
        LinkedList<Mapper.Option> mapperOptions = new LinkedList<Mapper.Option>();
        if (options.consistency != null) {
            mapperOptions.add(Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.valueOf((String)options.consistency.name())));
        } else if (this.getWriteOptions() != null && this.getWriteOptions().consistency != null) {
            mapperOptions.add(Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.valueOf((String)this.getWriteOptions().consistency.name())));
        }
        if (options.ttl != null) {
            mapperOptions.add(Mapper.Option.ttl((int)options.ttl));
        } else if (this.getWriteOptions() != null && this.getWriteOptions().ttl != null) {
            mapperOptions.add(Mapper.Option.ttl((int)this.getWriteOptions().ttl));
        }
        if (options.saveNullFields != null) {
            mapperOptions.add(Mapper.Option.saveNullFields((boolean)options.saveNullFields));
        } else if (this.getWriteOptions() != null && this.getWriteOptions().saveNullFields != null) {
            mapperOptions.add(Mapper.Option.saveNullFields((boolean)this.getWriteOptions().saveNullFields));
        }
        if (options.ifNotExists != null) {
            mapperOptions.add(Mapper.Option.ifNotExists((boolean)options.ifNotExists));
        } else if (this.getWriteOptions() != null && this.getWriteOptions().ifNotExists != null) {
            mapperOptions.add(Mapper.Option.ifNotExists((boolean)this.getWriteOptions().ifNotExists));
        }
        return mapperOptions.toArray(new Mapper.Option[0]);
    }

    private Mapper.Option[] readOptions(ReadOptions userOptions) {
        LinkedList<Mapper.Option> mapperOptions = new LinkedList<Mapper.Option>();
        ReadOptions options = ReadOptions.from(userOptions);
        if (options.consistency != null) {
            mapperOptions.add(Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.valueOf((String)options.consistency.name())));
        } else if (this.getReadOptions() != null && this.getReadOptions().consistency != null) {
            mapperOptions.add(Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.valueOf((String)this.getReadOptions().consistency.name())));
        }
        return mapperOptions.toArray(new Mapper.Option[0]);
    }

    @Override
    public <T> void delete(Class<T> cls, T entity) {
        this.getMapper(cls).delete(entity);
    }

    @Override
    public <T> T get(Class<T> cls, PrimaryKey primaryKey) {
        return (T)this.getMapper(cls).get(primaryKey.getKeys());
    }

    @Override
    public <T> T get(Class<T> cls, PrimaryKey primaryKey, ReadOptions options) {
        Mapper<T> mapper = this.getMapper(cls);
        mapper.setDefaultGetOptions(this.readOptions(options));
        return (T)this.getMapper(cls).get(primaryKey.getKeys());
    }

    @Override
    public <X> AsyncFutures<X, PrimaryKey> get(Collection<PrimaryKey> list, Class<X> cls, ReadOptions userOptions) {
        Async async = this.createAsync();
        Mapper mapper = this.getMapper(cls);
        mapper.setDefaultGetOptions(this.readOptions(userOptions));
        return async.accept(list, k -> mapper.getAsync(k.getKeys()));
    }

    public <T> List<T> mapAll(Class<T> cls, BaseResultSet rs) {
        return this.getMapper(cls).map((com.datastax.driver.core.ResultSet)((ResultSetV3)rs).unwrap()).all();
    }

    public <T> Mapper<T> getMapper(Class<T> cls) {
        return this.getMappingManager().mapper(cls);
    }
}

