/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.mapping.DefaultNamingStrategy;
import com.datastax.driver.mapping.DefaultPropertyMapper;
import com.datastax.driver.mapping.MappingConfiguration;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.NamingConventions;
import com.datastax.driver.mapping.NamingStrategy;
import com.datastax.driver.mapping.PropertyMapper;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.Session;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.driver.Wrapper;
import net.e6tech.elements.cassandra.driver.v3.GeneratorV3;
import net.e6tech.elements.cassandra.driver.v3.SessionV3;
import net.e6tech.elements.cassandra.driver.v3.SibylV3;
import net.e6tech.elements.cassandra.driver.v3.TableMetadataV3;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.TextBuilder;

public class SessionProviderV3
extends SessionProvider {
    private Generator generator = new GeneratorV3();
    private NamingStrategy namingStrategy = new DefaultNamingStrategy(NamingConventions.LOWER_CAMEL_CASE, NamingConventions.LOWER_SNAKE_CASE);
    private Cluster cluster;
    private MappingManager sharedMappingManager;
    private Deque<MappingManager> cachedManagers = new ConcurrentLinkedDeque<MappingManager>();
    private Consumer<Cluster.Builder> builderOptions;
    private volatile boolean sharedInitialized = false;

    @Override
    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    protected Session createSession(String keyspaceIn) {
        com.datastax.driver.core.Session session = this.cluster.connect(keyspaceIn);
        return Wrapper.wrap(new SessionV3(), session);
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public Consumer<Cluster.Builder> getBuilderOptions() {
        return this.builderOptions;
    }

    public void setBuilderOptions(Consumer<Cluster.Builder> builderOptions) {
        this.builderOptions = builderOptions;
    }

    @Override
    public net.e6tech.elements.cassandra.driver.metadata.TableMetadata getTableMetadata(String keyspaceIn, String tableName) {
        TableMetadata metadata = this.cluster.getMetadata().getKeyspace(this.getKeyspace(keyspaceIn)).getTable(tableName);
        if (metadata == null) {
            return null;
        }
        return new TableMetadataV3(this.generator, metadata);
    }

    protected MappingManager createMappingManager(com.datastax.driver.core.Session session) {
        DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper();
        propertyMapper.setNamingStrategy(this.namingStrategy);
        MappingConfiguration conf = MappingConfiguration.builder().withPropertyMapper((PropertyMapper)propertyMapper).build();
        return new MappingManager(session, conf);
    }

    protected synchronized void buildCluster() {
        if (this.cluster != null) {
            return;
        }
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setHeartbeatIntervalSeconds(this.getHeartbeatIntervalSeconds()).setPoolTimeoutMillis(this.getPoolTimeout()).setCoreConnectionsPerHost(HostDistance.LOCAL, this.getCoreConnections()).setMaxConnectionsPerHost(HostDistance.LOCAL, this.getMaxConnections()).setMaxRequestsPerConnection(HostDistance.LOCAL, this.getMaxRequests());
        SocketOptions socketOptions = new SocketOptions().setReadTimeoutMillis(this.getReadTimeout());
        if (this.getKeepAlive() != null) {
            socketOptions.setKeepAlive(this.getKeepAlive().booleanValue());
        }
        Cluster.Builder builder = Cluster.builder().addContactPoint(this.getHost()).withPort(this.getPort()).withPoolingOptions(poolingOptions).withSocketOptions(socketOptions).withoutJMXReporting();
        if (this.getBuilderOptions() != null) {
            this.getBuilderOptions().accept(builder);
        }
        this.cluster = builder.build();
    }

    @Override
    protected void initGenerator() {
        GeneratorV3 gen = new GeneratorV3();
        gen.setNamingStrategy(this.namingStrategy);
        this.generator = gen;
    }

    @Override
    protected void initDriver() {
        this.buildCluster();
    }

    @Override
    protected void initKeyspace() {
        com.datastax.driver.core.Session session;
        try {
            session = this.cluster.connect(this.getKeyspace());
        }
        catch (InvalidQueryException ex) {
            session = this.cluster.connect();
            this.createKeyspaceArguments.put("keyspace", this.getKeyspace());
            session.execute(TextBuilder.using((String)this.createKeyspace).build(this.createKeyspaceArguments));
        }
        session.close();
    }

    @Override
    protected void postInit() {
        this.getProvision().getResourceManager().rebind(Cluster.class, (Object)this.cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Resources resources) {
        MappingManager mappingManager;
        com.datastax.driver.core.Session session;
        if (this.isSharedSession()) {
            if (!this.sharedInitialized) {
                SessionProviderV3 sessionProviderV3 = this;
                synchronized (sessionProviderV3) {
                    if (!this.sharedInitialized) {
                        this.cluster.connect(this.getKeyspace());
                        session = this.cluster.connect(this.getKeyspace());
                        this.sharedMappingManager = this.createMappingManager(session);
                    }
                }
            }
            mappingManager = this.sharedMappingManager;
            session = mappingManager.getSession();
        } else {
            try {
                mappingManager = this.cachedManagers.pop();
                session = mappingManager.getSession();
            }
            catch (NoSuchElementException ex) {
                this.cluster.connect(this.getKeyspace());
                session = this.cluster.connect(this.getKeyspace());
                mappingManager = this.createMappingManager(session);
            }
        }
        resources.rebind(com.datastax.driver.core.Session.class, (Object)session);
        resources.rebind(Session.class, (Object)Wrapper.wrap(new SessionV3(), session));
        resources.rebind(MappingManager.class, (Object)mappingManager);
        resources.rebind(Cluster.class, (Object)this.cluster);
        resources.rebind(SessionProvider.class, (Object)this);
        Sibyl s = (Sibyl)resources.newInstance(SibylV3.class);
        s.setReadOptions(this.getDefaultReadOptions());
        s.setWriteOptions(this.getDefaultWriteOptions());
        resources.rebind(Sibyl.class, (Object)s);
    }

    public void onClosed(Resources resources) {
        if (this.isSharedSession()) {
            return;
        }
        MappingManager mappingManager = (MappingManager)resources.getInstance(MappingManager.class);
        if (mappingManager != null) {
            if (this.cachedManagers.size() < this.getMaxSessions()) {
                this.cachedManagers.push(mappingManager);
            } else {
                mappingManager.getSession().closeAsync();
            }
        }
    }

    public void onShutdown() {
        if (this.isSharedSession()) {
            if (this.sharedMappingManager != null) {
                this.sharedMappingManager.getSession().close();
            }
        } else {
            for (MappingManager mappingManager : this.cachedManagers) {
                mappingManager.getSession().close();
            }
        }
    }
}

